/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatementCollectorTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testStatementCollector() throws Exception {
        StatementCollector collector = new StatementCollector();
        Assert.assertNotNull((Object)collector.getStatements());
        Assert.assertNotNull((Object)collector.getNamespaces());
    }

    @Test
    public final void testStatementCollectorList() throws Exception {
        ArrayList testList = new ArrayList();
        StatementCollector collector = new StatementCollector(testList);
        Assert.assertTrue((testList == collector.getStatements() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)collector.getNamespaces());
    }

    @Test
    public final void testStatementCollectorSet() throws Exception {
        LinkedHashSet testList = new LinkedHashSet();
        StatementCollector collector = new StatementCollector(testList);
        Assert.assertTrue((testList == collector.getStatements() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)collector.getNamespaces());
    }

    @Test
    public final void testStatementCollectorCollectionModel() throws Exception {
        LinkedHashModel testList = new LinkedHashModel();
        StatementCollector collector = new StatementCollector((Collection)testList);
        Assert.assertTrue((testList == collector.getStatements() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)collector.getNamespaces());
        Assert.assertTrue((boolean)testList.getNamespaces().isEmpty());
        Assert.assertTrue((boolean)collector.getNamespaces().isEmpty());
        collector.handleNamespace("ns1", "http://example.org/ns1#");
        Assert.assertFalse((boolean)testList.getNamespaces().isEmpty());
        Assert.assertFalse((boolean)collector.getNamespaces().isEmpty());
        Assert.assertTrue((boolean)collector.getNamespaces().containsKey("ns1"));
        Assert.assertTrue((boolean)collector.getNamespaces().containsValue("http://example.org/ns1#"));
        Assert.assertTrue((boolean)((Namespace)testList.getNamespaces().iterator().next()).getPrefix().equals("ns1"));
        Assert.assertTrue((boolean)((Namespace)testList.getNamespaces().iterator().next()).getName().equals("http://example.org/ns1#"));
    }

    @Test
    public final void testStatementCollectorCollectionModelMapIndependent() throws Exception {
        LinkedHashModel testList = new LinkedHashModel();
        LinkedHashMap testNamespaces = new LinkedHashMap();
        StatementCollector collector = new StatementCollector((Collection)testList, testNamespaces);
        Assert.assertTrue((testList == collector.getStatements() ? 1 : 0) != 0);
        Assert.assertTrue((testNamespaces == collector.getNamespaces() ? 1 : 0) != 0);
    }

    @Test
    public final void testStatementCollectorCollectionMapModel() throws Exception {
        LinkedHashModel testList = new LinkedHashModel();
        LinkedHashMap testNamespaces = new LinkedHashMap();
        StatementCollector collector = new StatementCollector((Collection)testList, testNamespaces);
        Assert.assertTrue((testList == collector.getStatements() ? 1 : 0) != 0);
        Assert.assertTrue((testNamespaces == collector.getNamespaces() ? 1 : 0) != 0);
    }

    @Test
    public final void testStartRDF() throws Exception {
        StatementCollector testCollector = new StatementCollector();
        testCollector.startRDF();
    }

    @Test
    public final void testEndRDF() throws Exception {
        StatementCollector testCollector = new StatementCollector();
        testCollector.startRDF();
        testCollector.endRDF();
    }

    @Test
    public final void testHandleComment() throws Exception {
        StatementCollector testCollector = new StatementCollector();
        testCollector.handleComment("Comment");
    }
}

