/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ndjsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.jsonld.JSONLDParser;

public class NDJSONLDParser
extends JSONLDParser
implements RDFParser {
    public NDJSONLDParser() {
    }

    public NDJSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NDJSONLD;
    }

    @Override
    protected Object getJSONObject(InputStream in, Reader reader, JsonFactory factory) throws IOException {
        LinkedList<Object> arrayOfJSONLD = new LinkedList<Object>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                JsonParser nextParser = factory.createParser((InputStream)new ByteArrayInputStream(line.getBytes()));
                Object singleJSONLD = JsonUtils.fromJsonParser((JsonParser)nextParser);
                if (singleJSONLD instanceof List) {
                    arrayOfJSONLD.addAll((List)singleJSONLD);
                    continue;
                }
                arrayOfJSONLD.add(singleJSONLD);
            }
            LinkedList<Object> linkedList = arrayOfJSONLD;
            return linkedList;
        }
    }

    @Override
    public void parse(InputStream in, String baseURI) throws RDFParseException, RDFHandlerException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be 'null'");
        }
        this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), StandardCharsets.UTF_8), baseURI);
    }
}

