/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParserSettings;

public class NQuadsParser
extends NTriplesParser {
    protected Resource context;

    public NQuadsParser() {
    }

    public NQuadsParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    protected void parseStatement() throws RDFParseException, RDFHandlerException {
        boolean ignoredAnError = false;
        try {
            this.skipWhitespace(false);
            if (!this.shouldParseLine()) {
                return;
            }
            this.parseSubject();
            this.skipWhitespace(true);
            this.parsePredicate();
            this.skipWhitespace(true);
            this.parseObject();
            this.skipWhitespace(true);
            this.parseContext();
            this.skipWhitespace(true);
            this.assertLineTerminates();
        }
        catch (RDFParseException e) {
            if (this.getParserConfig().isNonFatalError((RioSetting)NTriplesParserSettings.FAIL_ON_INVALID_LINES)) {
                this.reportError((Exception)((Object)e), (RioSetting)NTriplesParserSettings.FAIL_ON_INVALID_LINES);
                ignoredAnError = true;
            }
            throw e;
        }
        this.handleStatement(ignoredAnError);
    }

    protected void parseContext() {
        if (this.lineChars[this.currentIndex] == '<') {
            this.context = this.parseIRI();
        } else if (this.lineChars[this.currentIndex] == '_') {
            this.context = this.parseNode();
        }
    }

    protected void handleStatement(boolean ignoredAnError) {
        if (this.rdfHandler != null && !ignoredAnError) {
            if (this.context == null) {
                this.rdfHandler.handleStatement(this.valueFactory.createStatement(this.subject, this.predicate, this.object));
            } else {
                this.rdfHandler.handleStatement(this.valueFactory.createStatement(this.subject, this.predicate, this.object, this.context));
            }
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
        this.context = null;
    }
}

