/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class NTriplesWriter
extends AbstractRDFWriter
implements RDFWriter {
    protected final Writer writer;
    protected boolean writingStarted;
    private boolean xsdStringToPlainLiteral = true;
    private boolean escapeUnicode;

    public NTriplesWriter(OutputStream out) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public NTriplesWriter(Writer writer) {
        this.writer = writer;
        this.writingStarted = false;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
        this.xsdStringToPlainLiteral = (Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        this.escapeUnicode = (Boolean)this.getWriterConfig().get(NTriplesWriterSettings.ESCAPE_UNICODE);
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            this.writeValue((Value)st.getSubject());
            this.writer.write(" ");
            this.writeIRI(st.getPredicate());
            this.writer.write(" ");
            this.writeValue(st.getObject());
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        result.add(NTriplesWriterSettings.ESCAPE_UNICODE);
        return result;
    }

    protected void writeValue(Value value) throws IOException {
        if (value instanceof IRI) {
            this.writeIRI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass());
        }
    }

    private void writeIRI(IRI iri) throws IOException {
        NTriplesUtil.append(iri, (Appendable)this.writer);
    }

    private void writeBNode(BNode bNode) throws IOException {
        String nextId = bNode.getID();
        this.writer.append("_:");
        if (nextId.isEmpty()) {
            this.writer.append("genid");
            this.writer.append(Integer.toHexString(bNode.hashCode()));
        } else {
            if (!NTriplesUtil.isLetter(nextId.charAt(0))) {
                this.writer.append("genid");
                this.writer.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (NTriplesUtil.isLetterOrNumber(nextId.charAt(i))) {
                    this.writer.append(nextId.charAt(i));
                    continue;
                }
                this.writer.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
    }

    private void writeLiteral(Literal lit) throws IOException {
        NTriplesUtil.append(lit, (Appendable)this.writer, (boolean)((Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL)), this.escapeUnicode);
    }
}

