/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.rio.ntriples;

import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.testsuite.rio.FailureMode;
import org.eclipse.rdf4j.testsuite.rio.NegativeParserTest;
import org.eclipse.rdf4j.testsuite.rio.PositiveParserTest;

public abstract class AbstractNTriplesParserTest {
    private static final String TEST_W3C_FILE_BASE_PATH = "/testcases/ntriples/";
    private static final String TEST_W3C_MANIFEST_URL = "/testcases/ntriples/manifest.ttl";
    private static final String TEST_W3C_MANIFEST_URI_BASE = "http://www.w3.org/2013/N-TriplesTests/manifest.ttl#";
    private static final String TEST_W3C_TEST_URI_BASE = "http://www.w3.org/2013/N-TriplesTests/";

    public TestSuite createTestSuite() throws Exception {
        TestSuite suite = new TestSuite(this.getClass().getName());
        SailRepository w3cRepository = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection w3cCon = w3cRepository.getConnection();){
            InputStream inputStream = this.getClass().getResourceAsStream(TEST_W3C_MANIFEST_URL);
            w3cCon.add(inputStream, TEST_W3C_MANIFEST_URI_BASE, RDFFormat.TURTLE, new Resource[0]);
            this.parsePositiveNTriplesSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TEST_W3C_TEST_URI_BASE, w3cCon);
            this.parseNegativeNTriplesSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TEST_W3C_TEST_URI_BASE, w3cCon);
        }
        w3cRepository.shutDown();
        return suite;
    }

    private void parsePositiveNTriplesSyntaxTests(TestSuite suite, String fileBasePath, String testLocationBaseUri, RepositoryConnection con) {
        StringBuilder positiveQuery = new StringBuilder();
        positiveQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveQuery.append(" WHERE { \n");
        positiveQuery.append("     ?test a rdft:TestNTriplesPositiveSyntax . ");
        positiveQuery.append("     ?test mf:name ?testName . ");
        positiveQuery.append("     ?test mf:action ?inputURL . ");
        positiveQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), testLocationBaseUri);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testLocationBaseUri + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, null, nextBaseUrl, this.createRDFParser(), this.createRDFParser()));
        }
        queryResult.close();
    }

    private void parseNegativeNTriplesSyntaxTests(TestSuite suite, String fileBasePath, String testLocationBaseUri, RepositoryConnection con) {
        StringBuilder negativeQuery = new StringBuilder();
        negativeQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeQuery.append(" WHERE { \n");
        negativeQuery.append("     ?test a rdft:TestNTriplesNegativeSyntax . ");
        negativeQuery.append("     ?test mf:name ?testName . ");
        negativeQuery.append("     ?test mf:action ?inputURL . ");
        negativeQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).toString();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), testLocationBaseUri);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testLocationBaseUri + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createRDFParser(), FailureMode.DO_NOT_IGNORE_FAILURE));
        }
        queryResult.close();
    }

    protected abstract RDFParser createRDFParser();

    private String removeBase(String baseUrl, String redundantBaseUrl) {
        if (baseUrl.startsWith(redundantBaseUrl)) {
            return baseUrl.substring(redundantBaseUrl.length());
        }
        return baseUrl;
    }
}

