/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.rio.trig;

import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.testsuite.rio.FailureMode;
import org.eclipse.rdf4j.testsuite.rio.NegativeParserTest;
import org.eclipse.rdf4j.testsuite.rio.PositiveParserTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TriGParserTestCase {
    protected static String TESTS_W3C_BASE_URL = "http://www.w3.org/2013/TriGTests/";
    private static final String TEST_W3C_FILE_BASE_PATH = "/testcases/trig/";
    private static final String TEST_W3C_MANIFEST_URL = "/testcases/trig/manifest.ttl";
    private static final String TEST_W3C_MANIFEST_URI_BASE = "http://www.w3.org/2013/TriGTests/manifest.ttl#";
    private static final String TEST_W3C_TEST_URI_BASE = "http://www.w3.org/2013/TriGTests/";
    private static final Logger logger = LoggerFactory.getLogger(TriGParserTestCase.class);

    public TestSuite createTestSuite() throws Exception {
        TestSuite suite = new TestSuite(TriGParserTestCase.class.getName());
        SailRepository w3cRepository = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection w3cCon = w3cRepository.getConnection();){
            InputStream inputStream = this.getClass().getResourceAsStream(TEST_W3C_MANIFEST_URL);
            w3cCon.add(inputStream, TEST_W3C_MANIFEST_URI_BASE, RDFFormat.TURTLE, new Resource[0]);
            this.parsePositiveTriGSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
            this.parseNegativeTriGSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
            this.parsePositiveTriGEvalTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
            this.parseNegativeTriGEvalTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
        }
        w3cRepository.shutDown();
        return suite;
    }

    private void parsePositiveTriGSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String testLocationBaseUri, RepositoryConnection con) {
        StringBuilder positiveQuery = new StringBuilder();
        positiveQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveQuery.append(" WHERE { \n");
        positiveQuery.append("     ?test a rdft:TestTrigPositiveSyntax . ");
        positiveQuery.append("     ?test mf:name ?testName . ");
        positiveQuery.append("     ?test mf:action ?inputURL . ");
        positiveQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), testLocationBaseUri);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, null, nextBaseUrl, this.createTriGParser(), this.createNQuadsParser()));
        }
        queryResult.close();
    }

    private void parseNegativeTriGSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) {
        StringBuilder negativeQuery = new StringBuilder();
        negativeQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeQuery.append(" WHERE { \n");
        negativeQuery.append("     ?test a rdft:TestTrigNegativeSyntax . ");
        negativeQuery.append("     ?test mf:name ?testName . ");
        negativeQuery.append("     ?test mf:action ?inputURL . ");
        negativeQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createTriGParser(), FailureMode.DO_NOT_IGNORE_FAILURE));
        }
        queryResult.close();
    }

    private void parsePositiveTriGEvalTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) {
        StringBuilder positiveEvalQuery = new StringBuilder();
        positiveEvalQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveEvalQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveEvalQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveEvalQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveEvalQuery.append(" WHERE { \n");
        positiveEvalQuery.append("     ?test a rdft:TestTrigEval . ");
        positiveEvalQuery.append("     ?test mf:name ?testName . ");
        positiveEvalQuery.append("     ?test mf:action ?inputURL . ");
        positiveEvalQuery.append("     ?test mf:result ?outputURL . ");
        positiveEvalQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveEvalQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextOutputURL = fileBasePath + this.removeBase(((IRI)bindingSet.getValue("outputURL")).toString(), manifestBaseUrl);
            String nextBaseUrl = testBaseUrl + nextTestFile;
            if (nextTestName.contains("CARRIAGE_RETURN")) {
                logger.warn("Ignoring TriG Positive Parser Eval Test: " + nextInputURL);
                continue;
            }
            if (nextTestName.contains("UTF8_boundaries") || nextTestName.contains("PN_CHARS_BASE_character_boundaries")) {
                logger.warn("Ignoring TriG Positive Parser Eval Test: " + nextInputURL);
                continue;
            }
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, nextOutputURL, nextBaseUrl, this.createTriGParser(), this.createNQuadsParser()));
        }
        queryResult.close();
    }

    private void parseNegativeTriGEvalTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) {
        StringBuilder negativeEvalQuery = new StringBuilder();
        negativeEvalQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeEvalQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeEvalQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeEvalQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeEvalQuery.append(" WHERE { \n");
        negativeEvalQuery.append("     ?test a rdft:TestTrigNegativeEval . ");
        negativeEvalQuery.append("     ?test mf:name ?testName . ");
        negativeEvalQuery.append("     ?test mf:action ?inputURL . ");
        negativeEvalQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeEvalQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).stringValue(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createTriGParser(), FailureMode.DO_NOT_IGNORE_FAILURE));
        }
        queryResult.close();
    }

    protected abstract RDFParser createTriGParser();

    protected abstract RDFParser createNQuadsParser();

    private String removeBase(String baseUrl, String redundantBaseUrl) {
        if (baseUrl.startsWith(redundantBaseUrl)) {
            return baseUrl.substring(redundantBaseUrl.length());
        }
        return baseUrl;
    }
}

