/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

class ArrangedWriter
implements RDFWriter {
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private final RDFWriter delegate;
    private boolean repeatBlankNodes;
    private int targetQueueSize;
    private int queueSize = 0;
    private final Deque<SubjectInContext> stack = new LinkedList<SubjectInContext>();
    private final Map<String, String> prefixes = new TreeMap<String, String>();
    private final Map<SubjectInContext, Set<Statement>> stmtBySubject = new LinkedHashMap<SubjectInContext, Set<Statement>>();
    private final Model blanks = new LinkedHashModel();
    private final Model blankReferences = new LinkedHashModel();
    private final Comparator<Statement> comparator = new Comparator<Statement>(){

        @Override
        public int compare(Statement s1, Statement s2) {
            Value o2;
            IRI p1 = s1.getPredicate();
            IRI p2 = s2.getPredicate();
            if (p1.equals((Object)RDF.TYPE) && !p2.equals((Object)RDF.TYPE)) {
                return -1;
            }
            if (!p1.equals((Object)RDF.TYPE) && p2.equals((Object)RDF.TYPE)) {
                return 1;
            }
            int cmp = p1.stringValue().compareTo(p2.stringValue());
            if (cmp != 0) {
                return cmp;
            }
            Value o1 = s1.getObject();
            if (o1.equals(o2 = s2.getObject())) {
                return 0;
            }
            if (!(o1 instanceof BNode) && o2 instanceof BNode) {
                return -1;
            }
            if (o1 instanceof BNode && !(o2 instanceof BNode)) {
                return 1;
            }
            if (!(o1 instanceof IRI) && o2 instanceof IRI) {
                return -1;
            }
            if (o1 instanceof IRI && !(o2 instanceof IRI)) {
                return 1;
            }
            int str_cmp = o1.stringValue().compareTo(o2.stringValue());
            if (str_cmp != 0) {
                return str_cmp;
            }
            Literal lit1 = (Literal)o1;
            Literal lit2 = (Literal)o2;
            int dt_cmp = lit1.getDatatype().stringValue().compareTo(lit2.getDatatype().stringValue());
            if (dt_cmp != 0) {
                return dt_cmp;
            }
            return lit1.getLanguage().orElse("").compareTo(lit2.getLanguage().orElse(""));
        }
    };

    public ArrangedWriter(RDFWriter delegate) {
        this(delegate, 0);
    }

    public ArrangedWriter(RDFWriter delegate, int size) {
        this(delegate, size, size == -1);
    }

    public ArrangedWriter(RDFWriter delegate, int size, boolean repeatBlankNodes) {
        this.delegate = delegate;
        this.targetQueueSize = size;
        this.repeatBlankNodes = repeatBlankNodes;
    }

    public RDFFormat getRDFFormat() {
        return this.delegate.getRDFFormat();
    }

    public RDFWriter setWriterConfig(WriterConfig config) {
        return this.delegate.setWriterConfig(config);
    }

    public WriterConfig getWriterConfig() {
        return this.delegate.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.delegate.getSupportedSettings();
    }

    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        return this.delegate.set(setting, value);
    }

    public void startRDF() throws RDFHandlerException {
        if (((Boolean)this.getWriterConfig().get(BasicWriterSettings.INLINE_BLANK_NODES)).booleanValue()) {
            this.targetQueueSize = -1;
            this.repeatBlankNodes = true;
        } else if (((Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
            this.targetQueueSize = 100;
        }
        this.delegate.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.trimNamespaces();
        this.flushStatements();
        this.delegate.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.flushStatements();
        if (this.targetQueueSize == 0) {
            this.delegate.handleNamespace(prefix, uri);
        } else if (!this.prefixes.containsKey(uri)) {
            this.prefixes.put(uri, prefix);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.flushStatements();
        this.delegate.handleComment(comment);
    }

    public synchronized void handleStatement(Statement st) throws RDFHandlerException {
        if (this.targetQueueSize == 0) {
            this.delegate.handleStatement(st);
        } else {
            this.queueStatement(st);
        }
        while (this.targetQueueSize >= 0 && this.queueSize > this.targetQueueSize) {
            this.flushNamespaces();
            this.delegate.handleStatement(this.nextStatement());
        }
    }

    private synchronized Statement nextStatement() {
        Value obj;
        if (this.stmtBySubject.isEmpty() && this.blanks.isEmpty()) {
            assert (this.queueSize == 0);
            return null;
        }
        Set<Statement> stmts = null;
        while (stmts == null) {
            SubjectInContext last = this.stack.peekLast();
            stmts = this.stmtBySubject.get(last);
            if (stmts == null && last != null && this.blanks.contains(last.getSubject(), null, null, new Resource[]{last.getContext()})) {
                stmts = this.queueBlankStatements(last);
            } else if (stmts == null) {
                this.stack.pollLast();
            }
            if (this.stack.isEmpty() && this.stmtBySubject.isEmpty()) {
                Statement st = (Statement)this.blanks.iterator().next();
                stmts = this.queueBlankStatements(new SubjectInContext(st));
                continue;
            }
            if (!this.stack.isEmpty()) continue;
            stmts = this.stmtBySubject.values().iterator().next();
        }
        Iterator iter = stmts.iterator();
        Statement next = (Statement)iter.next();
        --this.queueSize;
        iter.remove();
        SubjectInContext key = new SubjectInContext(next);
        if (!key.equals(this.stack.peekLast())) {
            this.stack.addLast(key);
        }
        if (!iter.hasNext()) {
            this.stmtBySubject.remove(key);
        }
        if ((obj = next.getObject()) instanceof BNode) {
            SubjectInContext bkey = new SubjectInContext((Resource)((BNode)obj), next.getContext());
            if (this.stack.contains(bkey)) {
                if (this.repeatBlankNodes) {
                    throw new RDFHandlerException("Blank node cycle detected. Try disabling " + BasicWriterSettings.INLINE_BLANK_NODES.getKey());
                }
            } else {
                this.stack.addLast(bkey);
            }
        }
        return next;
    }

    private synchronized Set<Statement> queueBlankStatements(SubjectInContext key) {
        Model matches;
        Model firstMatch = this.blanks.filter(key.getSubject(), null, null, new Resource[]{key.getContext()});
        Model model = matches = firstMatch.isEmpty() ? this.blankReferences.filter(key.getSubject(), null, null, new Resource[]{key.getContext()}) : firstMatch;
        if (matches.isEmpty()) {
            return null;
        }
        Set<Statement> set = this.stmtBySubject.get(key);
        if (set == null) {
            set = new TreeSet<Statement>(this.comparator);
            this.stmtBySubject.put(key, set);
        }
        set.addAll((Collection<Statement>)matches);
        if (firstMatch.isEmpty()) {
            this.queueSize += matches.size();
        } else {
            if (this.repeatBlankNodes && key.getSubject() instanceof BNode && this.isStillReferenced(key)) {
                this.blankReferences.addAll((Collection)matches);
            }
            this.blanks.remove(key.getSubject(), null, null, new Resource[]{key.getContext()});
        }
        return set;
    }

    private boolean isStillReferenced(SubjectInContext key) {
        if (this.blanks.contains(null, null, (Value)key.getSubject(), new Resource[]{key.getContext()})) {
            return true;
        }
        for (SubjectInContext subj : this.stack) {
            Set<Statement> stmts = this.stmtBySubject.get(subj);
            if (stmts == null) continue;
            for (Statement st : stmts) {
                if (!st.getObject().equals(key.getSubject()) && !Objects.equals(st.getContext(), key.getContext())) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void queueStatement(Statement st) {
        SubjectInContext key = new SubjectInContext(st);
        Set<Statement> stmts = this.stmtBySubject.get(key);
        if (stmts == null && st.getSubject() instanceof BNode && !this.stack.contains(key)) {
            this.blanks.add((Object)st);
        } else {
            if (stmts == null) {
                stmts = new TreeSet<Statement>(this.comparator);
                this.stmtBySubject.put(key, stmts);
            }
            stmts.add(st);
        }
        ++this.queueSize;
    }

    private synchronized void flushStatements() throws RDFHandlerException {
        if (!this.stmtBySubject.isEmpty() || !this.blanks.isEmpty()) {
            Statement st;
            this.flushNamespaces();
            while ((st = this.nextStatement()) != null) {
                this.delegate.handleStatement(st);
            }
            assert (this.queueSize == 0);
        }
    }

    private synchronized void flushNamespaces() throws RDFHandlerException {
        TreeMap<String, String> namespaces = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            namespaces.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            this.delegate.handleNamespace(entry.getKey(), entry.getValue());
        }
        this.prefixes.clear();
    }

    private synchronized void trimNamespaces() {
        if (!this.prefixes.isEmpty()) {
            HashSet<String> used = new HashSet<String>(this.prefixes.size());
            for (Set<Statement> stmts : this.stmtBySubject.values()) {
                this.getUsedNamespaces(stmts, used);
            }
            this.getUsedNamespaces((Set<Statement>)this.blanks, used);
            this.prefixes.keySet().retainAll(used);
        }
    }

    private void getUsedNamespaces(Set<Statement> stmts, Set<String> used) {
        for (Statement st : stmts) {
            Literal lit;
            used.add(st.getPredicate().getNamespace());
            if (st.getObject() instanceof IRI) {
                IRI uri = (IRI)st.getObject();
                used.add(uri.getNamespace());
                continue;
            }
            if (!(st.getObject() instanceof Literal) || (lit = (Literal)st.getObject()).getDatatype() == null) continue;
            used.add(lit.getDatatype().getNamespace());
        }
    }

    private class SubjectInContext {
        private Resource subject;
        private Resource context;

        private SubjectInContext(Statement st) {
            this(st.getSubject(), st.getContext());
        }

        private SubjectInContext(Resource subject, Resource context) {
            assert (subject != null);
            this.subject = subject;
            this.context = context;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public Resource getContext() {
            return this.context;
        }

        public String toString() {
            if (this.context == null) {
                return this.subject.toString();
            }
            return this.subject.toString() + " [" + this.context.toString() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.subject.hashCode();
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubjectInContext other = (SubjectInContext)obj;
            if (!this.subject.equals(other.subject)) {
                return false;
            }
            return !(this.context == null ? other.context != null : !this.context.equals(other.context));
        }
    }
}

