/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentResult;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchIndex;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.locationtech.spatial4j.context.SpatialContext;

public class ElasticsearchDocumentScore
extends ElasticsearchDocumentResult
implements DocumentScore {
    public ElasticsearchDocumentScore(SearchHit hit, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        super(hit, geoContextMapper);
    }

    public float getScore() {
        return this.hit.getScore();
    }

    public boolean isHighlighted() {
        return this.hit.getHighlightFields() != null;
    }

    public Iterable<String> getSnippets(String property) {
        HighlightField highlightField = (HighlightField)this.hit.getHighlightFields().get(ElasticsearchIndex.toPropertyFieldName(property));
        if (highlightField == null) {
            return null;
        }
        return Iterables.transform(Arrays.asList(highlightField.getFragments()), (Function)new Function<Text, String>(){

            public String apply(Text fragment) {
                return SearchFields.getSnippet((String)fragment.string());
            }
        });
    }
}

