/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.filters.AccurateRepositoryBloomFilter;
import org.eclipse.rdf4j.repository.filters.RepositoryBloomFilter;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.federation.Federation;
import org.eclipse.rdf4j.sail.federation.PrefixHashSet;
import org.eclipse.rdf4j.sail.federation.optimizers.EmptyPatternOptimizer;
import org.eclipse.rdf4j.sail.federation.optimizers.FederationJoinOptimizer;
import org.eclipse.rdf4j.sail.federation.optimizers.OwnedTupleExprPruner;
import org.eclipse.rdf4j.sail.federation.optimizers.PrepareOwnedTupleExpr;
import org.eclipse.rdf4j.sail.federation.optimizers.QueryModelPruner;
import org.eclipse.rdf4j.sail.federation.optimizers.QueryMultiJoinOptimizer;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFederationConnection
extends AbstractSailConnection
implements FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFederationConnection.class);
    private final Federation federation;
    private final ValueFactory valueFactory;
    protected final List<RepositoryConnection> members;
    private FederatedServiceResolver federatedServiceResolver;

    public AbstractFederationConnection(Federation federation, List<RepositoryConnection> members) {
        super(new AbstractSail(){

            public boolean isWritable() throws SailException {
                return false;
            }

            public ValueFactory getValueFactory() {
                return SimpleValueFactory.getInstance();
            }

            protected void shutDownInternal() throws SailException {
            }

            protected SailConnection getConnectionInternal() throws SailException {
                return null;
            }

            protected void connectionClosed(SailConnection connection) {
            }

            public List<IsolationLevel> getSupportedIsolationLevels() {
                return Arrays.asList(IsolationLevels.NONE);
            }

            public IsolationLevel getDefaultIsolationLevel() {
                return IsolationLevels.NONE;
            }
        });
        this.federation = federation;
        this.valueFactory = SimpleValueFactory.getInstance();
        this.members = new ArrayList<RepositoryConnection>(members.size());
        for (RepositoryConnection member : members) {
            this.members.add(member);
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void closeInternal() throws SailException {
        this.excute(new Procedure(){

            @Override
            public void run(RepositoryConnection con) throws RepositoryException {
                con.close();
            }
        });
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        DistinctIteration cursor = this.union(new Function<Resource>(){

            @Override
            public CloseableIteration<? extends Resource, RepositoryException> call(RepositoryConnection member) throws RepositoryException {
                return member.getContextIDs();
            }
        });
        cursor = new DistinctIteration(cursor);
        return cursor;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        if (this.federatedServiceResolver == null) {
            return this.federation.getFederatedServiceResolver();
        }
        return this.federatedServiceResolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.federatedServiceResolver = resolver;
        for (RepositoryConnection member : this.members) {
            if (!(member instanceof FederatedServiceResolverClient)) continue;
            ((FederatedServiceResolverClient)member).setFederatedServiceResolver(resolver);
        }
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        for (RepositoryConnection member : this.members) {
            if (!(member instanceof RepositoryResolverClient)) continue;
            ((RepositoryResolverClient)member).setRepositoryResolver(resolver);
        }
    }

    public HttpClientSessionManager getHttpClientSessionManager() {
        for (RepositoryConnection member : this.members) {
            HttpClientSessionManager client;
            if (!(member instanceof SessionManagerDependent) || (client = ((SessionManagerDependent)member).getHttpClientSessionManager()) == null) continue;
            return client;
        }
        return null;
    }

    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        for (RepositoryConnection member : this.members) {
            if (!(member instanceof SessionManagerDependent)) continue;
            ((SessionManagerDependent)member).setHttpClientSessionManager(client);
        }
    }

    public HttpClient getHttpClient() {
        for (RepositoryConnection member : this.members) {
            HttpClient client;
            if (!(member instanceof HttpClientDependent) || (client = ((HttpClientDependent)member).getHttpClient()) == null) continue;
            return client;
        }
        return null;
    }

    public void setHttpClient(HttpClient client) {
        for (RepositoryConnection member : this.members) {
            if (!(member instanceof HttpClientDependent)) continue;
            ((HttpClientDependent)member).setHttpClient(client);
        }
    }

    public String getNamespaceInternal(String prefix) throws SailException {
        try {
            String namespace = null;
            for (RepositoryConnection member : this.members) {
                String candidate = member.getNamespace(prefix);
                if (namespace == null) {
                    namespace = candidate;
                    continue;
                }
                if (candidate == null || candidate.equals(namespace)) continue;
                namespace = null;
                break;
            }
            return namespace;
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        HashMap<String, Namespace> namespaces = new HashMap<String, Namespace>();
        HashSet<String> prefixes = new HashSet<String>();
        HashSet<String> conflictedPrefixes = new HashSet<String>();
        try {
            for (RepositoryConnection member : this.members) {
                try (RepositoryResult memberNamespaces = member.getNamespaces();){
                    while (memberNamespaces.hasNext()) {
                        Namespace next = (Namespace)memberNamespaces.next();
                        String prefix = next.getPrefix();
                        if (prefixes.add(prefix)) {
                            namespaces.put(prefix, next);
                            continue;
                        }
                        if (next.getName().equals(((Namespace)namespaces.get(prefix)).getName())) continue;
                        conflictedPrefixes.add(prefix);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
        for (String prefix : conflictedPrefixes) {
            namespaces.remove(prefix);
        }
        return new CloseableIteratorIteration(namespaces.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sizeInternal(Resource ... contexts) throws SailException {
        long l;
        if (this.federation.isDistinct()) {
            long size = 0L;
            for (RepositoryConnection member : this.members) {
                size += member.size(contexts);
            }
            return size;
        }
        CloseableIteration cursor = this.getStatements(null, null, null, false, contexts);
        try {
            long size = 0L;
            while (cursor.hasNext()) {
                cursor.next();
                ++size;
            }
            l = size;
        }
        catch (Throwable throwable) {
            try {
                cursor.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new SailException((Throwable)e);
            }
        }
        cursor.close();
        return l;
    }

    public CloseableIteration<? extends Statement, SailException> getStatementsInternal(final Resource subj, final IRI pred, final Value obj, final boolean includeInferred, final Resource ... contexts) throws SailException {
        DistinctIteration cursor = this.union(new Function<Statement>(){

            @Override
            public CloseableIteration<? extends Statement, RepositoryException> call(RepositoryConnection member) throws RepositoryException {
                return member.getStatements(subj, pred, obj, includeInferred, contexts);
            }
        });
        if (!this.federation.isDistinct() && !this.isLocal(pred)) {
            cursor = new DistinctIteration(cursor);
        }
        return cursor;
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr query, Dataset dataset, BindingSet bindings, boolean inf) throws SailException {
        FederationTripleSource tripleSource = new FederationTripleSource(inf);
        EvaluationStrategy strategy = this.federation.createEvaluationStrategy(tripleSource, dataset, this.getFederatedServiceResolver());
        TupleExpr qry = this.optimize(query, dataset, bindings, inf, strategy);
        try {
            return strategy.evaluate(qry, EmptyBindingSet.getInstance());
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    private TupleExpr optimize(TupleExpr parsed, Dataset dataset, BindingSet bindings, boolean includeInferred, EvaluationStrategy strategy) throws SailException {
        LOGGER.trace("Incoming query model:\n{}", (Object)parsed);
        QueryRoot query = new QueryRoot(parsed.clone());
        new BindingAssigner().optimize((TupleExpr)query, dataset, bindings);
        new ConstantOptimizer(strategy).optimize((TupleExpr)query, dataset, bindings);
        new CompareOptimizer().optimize((TupleExpr)query, dataset, bindings);
        new ConjunctiveConstraintSplitter().optimize((TupleExpr)query, dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize((TupleExpr)query, dataset, bindings);
        new SameTermFilterOptimizer().optimize((TupleExpr)query, dataset, bindings);
        new QueryModelPruner().optimize((TupleExpr)query, dataset, bindings);
        new QueryMultiJoinOptimizer().optimize((TupleExpr)query, dataset, bindings);
        AccurateRepositoryBloomFilter defaultBloomFilter = new AccurateRepositoryBloomFilter(includeInferred);
        Map<Repository, RepositoryBloomFilter> bloomFilters = this.federation.getBloomFilters();
        java.util.function.Function<Repository, RepositoryBloomFilter> bloomFilterFunction = arg_0 -> AbstractFederationConnection.lambda$optimize$0(bloomFilters, (RepositoryBloomFilter)defaultBloomFilter, arg_0);
        new EmptyPatternOptimizer(this.members, bloomFilterFunction).optimize((TupleExpr)query, dataset, bindings);
        boolean distinct = this.federation.isDistinct();
        PrefixHashSet local = this.federation.getLocalPropertySpace();
        new FederationJoinOptimizer(this.members, distinct, local, bloomFilterFunction).optimize((TupleExpr)query, dataset, bindings);
        new OwnedTupleExprPruner().optimize((TupleExpr)query, dataset, bindings);
        new QueryModelPruner().optimize((TupleExpr)query, dataset, bindings);
        new QueryMultiJoinOptimizer().optimize((TupleExpr)query, dataset, bindings);
        new PrepareOwnedTupleExpr().optimize((TupleExpr)query, dataset, bindings);
        LOGGER.trace("Optimized query model:\n{}", (Object)query);
        return query;
    }

    void excute(Procedure operation) throws SailException {
        RepositoryException storeExc = null;
        RuntimeException runtimeExc = null;
        for (RepositoryConnection member : this.members) {
            try {
                operation.run(member);
            }
            catch (RepositoryException e) {
                LOGGER.error("Failed to execute procedure on federation members", (Throwable)e);
                if (storeExc != null) continue;
                storeExc = e;
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to execute procedure on federation members", (Throwable)e);
                if (runtimeExc != null) continue;
                runtimeExc = e;
            }
        }
        if (storeExc != null) {
            throw new SailException(storeExc);
        }
        if (runtimeExc != null) {
            throw runtimeExc;
        }
    }

    private <E> CloseableIteration<? extends E, SailException> union(Function<E> function) throws SailException {
        ArrayList<CloseableIteration<E, RepositoryException>> cursors = new ArrayList<CloseableIteration<E, RepositoryException>>(this.members.size());
        try {
            for (RepositoryConnection member : this.members) {
                cursors.add(function.call(member));
            }
            UnionIteration result = new UnionIteration(cursors);
            return new ExceptionConvertingIteration<E, SailException>((Iteration)result){

                protected SailException convert(Exception e) {
                    return new SailException((Throwable)e);
                }
            };
        }
        catch (RepositoryException e) {
            this.closeAll(cursors);
            throw new SailException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.closeAll(cursors);
            throw e;
        }
    }

    private boolean isLocal(IRI pred) {
        if (pred == null) {
            return false;
        }
        PrefixHashSet hash = this.federation.getLocalPropertySpace();
        if (hash == null) {
            return false;
        }
        return hash.match(pred.stringValue());
    }

    private void closeAll(Iterable<? extends CloseableIteration<?, RepositoryException>> cursors) {
        for (CloseableIteration<?, RepositoryException> cursor : cursors) {
            try {
                cursor.close();
            }
            catch (RepositoryException e) {
                LOGGER.error("Failed to close cursor", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ RepositoryBloomFilter lambda$optimize$0(Map bloomFilters, RepositoryBloomFilter defaultBloomFilter, Repository c) {
        return bloomFilters.getOrDefault(c, defaultBloomFilter);
    }

    private static interface Function<E> {
        public CloseableIteration<? extends E, RepositoryException> call(RepositoryConnection var1) throws RepositoryException;
    }

    static interface Procedure {
        public void run(RepositoryConnection var1) throws RepositoryException;
    }

    private class FederationTripleSource
    implements TripleSource {
        private final boolean inf;

        public FederationTripleSource(boolean includeInferred) {
            this.inf = includeInferred;
        }

        public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            try {
                CloseableIteration result = AbstractFederationConnection.this.getStatements(subj, pred, obj, this.inf, contexts);
                return new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)result){

                    protected QueryEvaluationException convert(Exception e) {
                        return new QueryEvaluationException((Throwable)e);
                    }
                };
            }
            catch (SailException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public ValueFactory getValueFactory() {
            return AbstractFederationConnection.this.valueFactory;
        }
    }
}

