/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.sail.federation.evaluation.QueueCursor;

public class ParallelJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private final EvaluationStrategy strategy;
    private final TupleExpr rightArg;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024);
    private final List<CloseableIteration<BindingSet, QueryEvaluationException>> toCloseList = new ArrayList<CloseableIteration<BindingSet, QueryEvaluationException>>();

    public ParallelJoinCursor(EvaluationStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg) throws QueryEvaluationException {
        this.strategy = strategy;
        this.leftIter = leftIter;
        this.rightArg = rightArg;
    }

    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            while (!this.isClosed() && this.leftIter.hasNext()) {
                CloseableIteration evaluate = this.strategy.evaluate(this.rightArg, (BindingSet)this.leftIter.next());
                this.toCloseList.add((CloseableIteration<BindingSet, QueryEvaluationException>)evaluate);
                this.rightQueue.put(evaluate);
            }
        }
        catch (RuntimeException e) {
            this.rightQueue.toss(e);
            this.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    public BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        CloseableIteration nextRightIter = this.rightIter;
        while (!this.isClosed() && (nextRightIter != null || this.rightQueue.hasNext())) {
            if (nextRightIter == null) {
                nextRightIter = this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (nextRightIter == null) continue;
            if (nextRightIter.hasNext()) {
                result = (BindingSet)nextRightIter.next();
                break;
            }
            nextRightIter.close();
            this.rightIter = null;
            nextRightIter = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleClose() throws QueryEvaluationException {
        this.closed = true;
        try {
            super.handleClose();
            return;
        }
        finally {
            try {
                CloseableIteration<BindingSet, QueryEvaluationException> toCloseRightIter = this.rightIter;
                this.rightIter = null;
                if (toCloseRightIter != null) {
                    toCloseRightIter.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    this.leftIter.close();
                    throw throwable;
                }
                finally {
                    try {
                        this.rightQueue.close();
                    }
                    finally {
                        try {
                            for (CloseableIteration<BindingSet, QueryEvaluationException> nextToCloseIteration : this.toCloseList) {
                                try {
                                    nextToCloseIteration.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        finally {
                            Thread toCloseEvaluationThread = this.evaluationThread;
                            if (toCloseEvaluationThread != null) {
                                toCloseEvaluationThread.interrupt();
                            }
                        }
                    }
                }
            }
            try {
                this.leftIter.close();
            }
            catch (Throwable throwable) {
                try {
                    this.rightQueue.close();
                    throw throwable;
                }
                finally {
                    try {
                        for (CloseableIteration<BindingSet, QueryEvaluationException> nextToCloseIteration : this.toCloseList) {
                            try {
                                nextToCloseIteration.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        Thread toCloseEvaluationThread = this.evaluationThread;
                        if (toCloseEvaluationThread != null) {
                            toCloseEvaluationThread.interrupt();
                        }
                    }
                }
            }
            try {
                this.rightQueue.close();
            }
            catch (Throwable throwable) {
                try {
                    Iterator<CloseableIteration<BindingSet, QueryEvaluationException>> iterator = this.toCloseList.iterator();
                    while (iterator.hasNext()) {
                        CloseableIteration<BindingSet, QueryEvaluationException> nextToCloseIteration = iterator.next();
                        try {
                            nextToCloseIteration.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                finally {
                    Thread toCloseEvaluationThread = this.evaluationThread;
                    if (toCloseEvaluationThread != null) {
                        toCloseEvaluationThread.interrupt();
                    }
                }
            }
            try {
                for (CloseableIteration closeableIteration : this.toCloseList) {
                    try {
                        closeableIteration.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                Thread toCloseEvaluationThread = this.evaluationThread;
                if (toCloseEvaluationThread != null) {
                    toCloseEvaluationThread.interrupt();
                }
            }
        }
    }

    public String toString() {
        String left = this.leftIter.toString().replace("\n", "\n\t");
        CloseableIteration<BindingSet, QueryEvaluationException> nextRightIter = this.rightIter;
        String right = null == nextRightIter ? this.rightArg.toString() : nextRightIter.toString();
        return "ParallelJoin\n\t" + left + "\n\t" + right.replace("\n", "\n\t");
    }
}

