/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

@Deprecated
public class FederationConfig
extends AbstractSailImplConfig {
    public static final String NAMESPACE = "http://www.openrdf.org/config/sail/federation#";
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final IRI MEMBER = vf.createIRI("http://www.openrdf.org/config/sail/federation#member");
    public static final IRI LOCALPROPERTYSPACE = vf.createIRI("http://www.openrdf.org/config/sail/federation#localPropertySpace");
    public static final IRI DISTINCT = vf.createIRI("http://www.openrdf.org/config/sail/federation#distinct");
    public static final IRI READ_ONLY = vf.createIRI("http://www.openrdf.org/config/sail/federation#readOnly");
    private List<RepositoryImplConfig> members = new ArrayList<RepositoryImplConfig>();
    private final Set<String> localPropertySpace = new HashSet<String>();
    private boolean distinct;
    private boolean readOnly;

    public List<RepositoryImplConfig> getMembers() {
        return this.members;
    }

    public void setMembers(List<RepositoryImplConfig> members) {
        this.members = members;
    }

    public void addMember(RepositoryImplConfig member) {
        this.members.add(member);
    }

    public Set<String> getLocalPropertySpace() {
        return this.localPropertySpace;
    }

    public void addLocalPropertySpace(String localPropertySpace) {
        this.localPropertySpace.add(localPropertySpace);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean disjoint) {
        this.distinct = disjoint;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Resource export(Model model) {
        SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
        Resource self = super.export(model);
        model.setNamespace("sf", NAMESPACE);
        for (RepositoryImplConfig member : this.getMembers()) {
            model.add(self, MEMBER, (Value)member.export(model), new Resource[0]);
        }
        for (String space : this.getLocalPropertySpace()) {
            model.add(self, LOCALPROPERTYSPACE, (Value)valueFactory.createIRI(space), new Resource[0]);
        }
        model.add(self, DISTINCT, (Value)valueFactory.createLiteral(this.distinct), new Resource[0]);
        model.add(self, READ_ONLY, (Value)valueFactory.createLiteral(this.readOnly), new Resource[0]);
        return self;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        LinkedHashModel model = new LinkedHashModel(graph);
        for (Value member : model.filter(implNode, MEMBER, null, new Resource[0]).objects()) {
            try {
                this.addMember(AbstractRepositoryImplConfig.create((Model)graph, (Resource)((Resource)member)));
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException((Throwable)e);
            }
        }
        for (Value space : model.filter(implNode, LOCALPROPERTYSPACE, null, new Resource[0]).objects()) {
            this.addLocalPropertySpace(space.stringValue());
        }
        try {
            Optional bool = Models.objectLiteral((Model)model.filter(implNode, DISTINCT, null, new Resource[0]));
            if (bool.isPresent() && ((Literal)bool.get()).booleanValue()) {
                this.distinct = true;
            }
            if ((bool = Models.objectLiteral((Model)model.filter(implNode, READ_ONLY, null, new Resource[0]))).isPresent() && ((Literal)bool.get()).booleanValue()) {
                this.readOnly = true;
            }
        }
        catch (ModelException e) {
            throw new SailConfigException((Throwable)e);
        }
    }

    public void validate() throws SailConfigException {
        super.validate();
        if (this.members.isEmpty()) {
            throw new SailConfigException("No federation members specified");
        }
        for (RepositoryImplConfig member : this.members) {
            try {
                member.validate();
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException((Throwable)e);
            }
        }
    }
}

