/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.EmptyModel;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SailSourceModel
extends AbstractModel {
    private static final Logger logger = LoggerFactory.getLogger(SailSourceModel.class);
    final SailSource source;
    SailDataset dataset;
    SailSink sink;
    private long size;
    private final IsolationLevels level = IsolationLevels.NONE;

    public SailSourceModel(SailStore store) {
        this(store.getExplicitSailSource());
    }

    public SailSourceModel(SailSource source) {
        this.source = source;
    }

    public void closeIterator(Iterator<?> iter) {
        super.closeIterator(iter);
        if (iter instanceof StatementIterator) {
            try {
                ((StatementIterator)iter).stmts.close();
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Iterator<Statement> it = this.iterator();
        try {
            if (!it.hasNext()) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < 100; ++i) {
                Statement e = it.next();
                sb.append((Object)(e == this ? "(this Collection)" : e));
                if (!it.hasNext()) {
                    String string = sb.append(']').toString();
                    return string;
                }
                sb.append(',').append(' ');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.closeIterator(it);
        }
    }

    public synchronized int size() {
        if (this.size < 0L) {
            try (CloseableIteration iter = this.dataset().getStatements(null, null, null, new Resource[0]);){
                while (iter.hasNext()) {
                    iter.next();
                    ++this.size;
                }
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        if (this.size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.size;
    }

    public Set<Namespace> getNamespaces() {
        LinkedHashSet<Namespace> set = new LinkedHashSet<Namespace>();
        try (CloseableIteration spaces = this.dataset().getNamespaces();){
            while (spaces.hasNext()) {
                set.add((Namespace)spaces.next());
            }
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return set;
    }

    public Optional<Namespace> getNamespace(String prefix) {
        try {
            String name = this.dataset().getNamespace(prefix);
            return Optional.of(new SimpleNamespace(prefix, name));
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public Namespace setNamespace(String prefix, String name) {
        try {
            this.sink().setNamespace(prefix, name);
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return new SimpleNamespace(prefix, name);
    }

    public void setNamespace(Namespace namespace) {
        this.setNamespace(namespace.getPrefix(), namespace.getName());
    }

    public Optional<Namespace> removeNamespace(String prefix) {
        Optional<Namespace> ret = this.getNamespace(prefix);
        try {
            this.sink().removeNamespace(prefix);
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return ret;
    }

    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            if (!this.isEmptyOrResourcePresent((Value[])contexts)) {
                return false;
            }
            return this.contains(this.dataset(), subj, pred, obj, contexts);
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public synchronized boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        try {
            if (this.contains(subj, pred, obj, contexts)) {
                logger.trace("already contains statement {} {} {} {}", new Object[]{subj, pred, obj, contexts});
                return false;
            }
            if (this.size >= 0L) {
                ++this.size;
            }
            if (contexts == null || contexts.length == 0) {
                this.sink().approve(subj, pred, obj, null);
            } else {
                for (Resource ctx : contexts) {
                    this.sink().approve(subj, pred, obj, ctx);
                }
            }
            return true;
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public synchronized boolean clear(Resource ... contexts) {
        try {
            if (this.contains(null, null, null, contexts)) {
                this.sink().clear(contexts);
                this.size = -1L;
                return true;
            }
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        block6: {
            try {
                if (!this.contains(subj, pred, obj, contexts)) break block6;
                this.size = -1L;
                try (CloseableIteration stmts = this.dataset().getStatements(subj, pred, obj, contexts);){
                    while (stmts.hasNext()) {
                        Statement st = (Statement)stmts.next();
                        this.sink().deprecate(st);
                    }
                }
                return true;
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }
        return false;
    }

    public Iterator<Statement> iterator() {
        try {
            return new StatementIterator((CloseableIteration<? extends Statement, SailException>)this.dataset().getStatements(null, null, null, new Resource[0]));
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (!this.isEmptyOrResourcePresent((Value[])contexts)) {
            return new EmptyModel((Model)this);
        }
        return new FilteredModel(this, subj, pred, obj, contexts){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public int size() {
                if (this.subj != null) return super.size();
                if (this.pred != null) return super.size();
                if (this.obj != null) return super.size();
                try (CloseableIteration iter = SailSourceModel.this.dataset().getStatements(null, null, null, new Resource[0]);){
                    long size = 0L;
                    while (iter.hasNext()) {
                        iter.next();
                        if (size++ < Integer.MAX_VALUE) continue;
                        int n = Integer.MAX_VALUE;
                        return n;
                    }
                    int n = (int)size;
                    return n;
                }
                catch (SailException e) {
                    throw new ModelException((Throwable)e);
                }
            }

            public Iterator<Statement> iterator() {
                try {
                    return new StatementIterator((CloseableIteration<? extends Statement, SailException>)SailSourceModel.this.dataset().getStatements(this.subj, this.pred, this.obj, this.contexts));
                }
                catch (SailException e) {
                    throw new ModelException((Throwable)e);
                }
            }

            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                SailSourceModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            try (CloseableIteration stmts = this.dataset().getStatements(subj, pred, obj, contexts);){
                while (stmts.hasNext()) {
                    Statement st = (Statement)stmts.next();
                    this.sink().deprecate(st);
                }
            }
            this.size = -1L;
        }
        catch (SailException e) {
            throw new ModelException((Throwable)e);
        }
    }

    private synchronized SailSink sink() throws SailException {
        if (this.sink == null) {
            this.sink = this.source.sink((IsolationLevel)this.level);
        }
        return this.sink;
    }

    private synchronized SailDataset dataset() throws SailException {
        if (this.sink != null) {
            try {
                this.sink.flush();
            }
            finally {
                this.sink.close();
                this.sink = null;
            }
            if (this.dataset != null) {
                this.dataset.close();
                this.dataset = null;
            }
        }
        if (this.dataset == null) {
            this.dataset = this.source.dataset((IsolationLevel)this.level);
        }
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(SailDataset dataset, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (dataset == null) {
            return false;
        }
        try (CloseableIteration stmts = dataset.getStatements(subj, pred, obj, contexts);){
            boolean bl = stmts.hasNext();
            return bl;
        }
    }

    private boolean isEmptyOrResourcePresent(Value[] contexts) {
        if (contexts instanceof Resource[]) {
            return true;
        }
        if (contexts == null) {
            return true;
        }
        if (contexts.length == 0) {
            return true;
        }
        Resource[] result = new Resource[contexts.length];
        for (int i = 0; i < result.length; ++i) {
            if (contexts[i] != null && !(contexts[i] instanceof Resource)) continue;
            return true;
        }
        return false;
    }

    Resource[] cast(Value[] contexts) {
        if (contexts instanceof Resource[]) {
            return (Resource[])contexts;
        }
        if (contexts == null) {
            return new Resource[]{null};
        }
        if (contexts.length == 0) {
            return new Resource[0];
        }
        Resource[] result = new Resource[contexts.length];
        for (int i = 0; i < result.length; ++i) {
            if (contexts[i] != null && !(contexts[i] instanceof Resource)) {
                ArrayList<Resource> list = new ArrayList<Resource>();
                for (Value v : contexts) {
                    if (v != null && !(v instanceof Resource)) continue;
                    list.add((Resource)v);
                }
                return list.toArray(new Resource[list.size()]);
            }
            result[i] = (Resource)contexts[i];
        }
        return result;
    }

    private final class StatementIterator
    implements Iterator<Statement> {
        final CloseableIteration<? extends Statement, SailException> stmts;
        Statement last;

        StatementIterator(CloseableIteration<? extends Statement, SailException> closeableIteration) {
            this.stmts = closeableIteration;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.stmts.hasNext()) {
                    return true;
                }
                this.stmts.close();
                return false;
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }

        @Override
        public Statement next() {
            try {
                this.last = (Statement)this.stmts.next();
                if (this.last == null) {
                    this.stmts.close();
                }
                return this.last;
            }
            catch (SailException e) {
                throw new ModelException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next() not yet called");
            }
            SailSourceModel.this.remove(this.last);
            this.last = null;
        }
    }
}

