/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.common.io.NioFile;

class TxnStatusFile {
    boolean disabled = false;
    public static final String FILE_NAME = "txn-status";
    private final NioFile nioFile;

    public void disable() {
        this.disabled = true;
    }

    public TxnStatusFile(File dataDir) throws IOException {
        File statusFile = new File(dataDir, FILE_NAME);
        this.nioFile = new NioFile(statusFile, "rwd");
    }

    public void close() throws IOException {
        this.nioFile.close();
    }

    public void setTxnStatus(TxnStatus txnStatus) throws IOException {
        if (this.disabled) {
            return;
        }
        if (txnStatus == TxnStatus.NONE) {
            this.nioFile.truncate(0L);
        } else {
            this.nioFile.writeBytes(txnStatus.onDisk, 0L);
        }
    }

    public TxnStatus getTxnStatus() throws IOException {
        TxnStatus status;
        if (this.disabled) {
            return TxnStatus.NONE;
        }
        byte[] bytes = this.nioFile.readBytes(0L, 1);
        switch (bytes[0]) {
            case 0: {
                status = TxnStatus.NONE;
                break;
            }
            case 1: {
                status = TxnStatus.NONE;
                break;
            }
            case 2: {
                status = TxnStatus.ACTIVE;
                break;
            }
            case 4: {
                status = TxnStatus.COMMITTING;
                break;
            }
            case 8: {
                status = TxnStatus.ROLLING_BACK;
                break;
            }
            case 16: {
                status = TxnStatus.UNKNOWN;
                break;
            }
            default: {
                status = this.getTxnStatusDeprecated();
            }
        }
        return status;
    }

    private TxnStatus getTxnStatusDeprecated() throws IOException {
        if (this.disabled) {
            return TxnStatus.NONE;
        }
        byte[] bytes = this.nioFile.readBytes(0L, (int)this.nioFile.size());
        String s = new String(bytes, StandardCharsets.US_ASCII);
        try {
            return TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            s = new String(bytes);
            try {
                return TxnStatus.valueOf(s);
            }
            catch (IllegalArgumentException e2) {
                return TxnStatus.UNKNOWN;
            }
        }
    }

    public static enum TxnStatus {
        NONE(0),
        ACTIVE(2),
        COMMITTING(4),
        ROLLING_BACK(8),
        UNKNOWN(16);

        private final byte[] onDisk = new byte[1];
        private static final byte NONE_BYTE = 0;
        private static final byte OLD_NONE_BYTE = 1;
        private static final byte ACTIVE_BYTE = 2;
        private static final byte COMMITTING_BYTE = 4;
        private static final byte ROLLING_BACK_BYTE = 8;
        private static final byte UNKNOWN_BYTE = 16;

        private TxnStatus(byte onDisk) {
            this.onDisk[0] = onDisk;
        }

        byte[] getOnDisk() {
            return this.onDisk;
        }
    }
}

