/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContextInitializer;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverImpl;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.AbstractForwardChainingInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.eclipse.rdf4j.sail.spin.SpinFunctionInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinMagicPropertyInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinSailConnection;
import org.eclipse.rdf4j.spin.SpinParser;

public class SpinSail
extends AbstractForwardChainingInferencer {
    private FunctionRegistry functionRegistry = FunctionRegistry.getInstance();
    private TupleFunctionRegistry tupleFunctionRegistry = TupleFunctionRegistry.getInstance();
    private FederatedServiceResolver serviceResolver = new FederatedServiceResolverImpl();
    private SpinParser parser = new SpinParser();
    private TupleFunctionEvaluationMode evaluationMode = TupleFunctionEvaluationMode.SERVICE;
    private List<QueryContextInitializer> queryContextInitializers = new ArrayList<QueryContextInitializer>();
    private boolean axiomClosureNeeded = true;

    public SpinSail() {
        super.setFederatedServiceResolver(this.serviceResolver);
    }

    public SpinSail(NotifyingSail baseSail) {
        super(baseSail);
        if (baseSail instanceof ForwardChainingRDFSInferencer) {
            this.setAxiomClosureNeeded(false);
        }
        super.setFederatedServiceResolver(this.serviceResolver);
    }

    public void setBaseSail(Sail baseSail) {
        super.setBaseSail(baseSail);
        if (baseSail instanceof ForwardChainingRDFSInferencer) {
            this.setAxiomClosureNeeded(false);
        }
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setFunctionRegistry(FunctionRegistry registry) {
        this.functionRegistry = registry;
    }

    public TupleFunctionRegistry getTupleFunctionRegistry() {
        return this.tupleFunctionRegistry;
    }

    public void setTupleFunctionRegistry(TupleFunctionRegistry registry) {
        this.tupleFunctionRegistry = registry;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        super.setFederatedServiceResolver(resolver);
    }

    public void setEvaluationMode(TupleFunctionEvaluationMode mode) {
        this.evaluationMode = mode;
    }

    public TupleFunctionEvaluationMode getEvaluationMode() {
        return this.evaluationMode;
    }

    public void setAxiomClosureNeeded(boolean axiomClosureNeeded) {
        this.axiomClosureNeeded = axiomClosureNeeded;
    }

    public boolean isAxiomClosureNeeded() {
        return this.axiomClosureNeeded;
    }

    public void addQueryContextInitializer(QueryContextInitializer initializer) {
        this.queryContextInitializers.add(initializer);
    }

    protected List<QueryContextInitializer> getQueryContextInitializers() {
        return this.queryContextInitializers;
    }

    public SpinParser getSpinParser() {
        return this.parser;
    }

    public void setSpinParser(SpinParser parser) {
        this.parser = parser;
    }

    public SpinSailConnection getConnection() throws SailException {
        InferencerConnection con = (InferencerConnection)super.getConnection();
        return new SpinSailConnection(this, con);
    }

    public void initialize() throws SailException {
        super.initialize();
        SpinFunctionInterpreter.registerSpinParsingFunctions(this.parser, this.functionRegistry);
        SpinMagicPropertyInterpreter.registerSpinParsingTupleFunctions(this.parser, this.tupleFunctionRegistry);
        try (SpinSailConnection con = this.getConnection();){
            con.begin();
            Set stmts = Iterations.asSet((Iteration)con.getStatements((Resource)this.getValueFactory().createIRI("http://spinrdf.org/sp"), RDF.TYPE, (Value)OWL.ONTOLOGY, true, new Resource[0]));
            if (stmts.isEmpty()) {
                con.addAxiomStatements();
            }
            con.commit();
        }
    }
}

