/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sail;

import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailChangedListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.testsuite.sail.RDFStoreTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class RDFNotifyingStoreTest
extends RDFStoreTest
implements SailChangedListener {
    private int removeEventCount;
    private int addEventCount;

    protected abstract NotifyingSail createSail() throws SailException;

    @BeforeEach
    public void addSailChangedListener() {
        ((NotifyingSail)this.sail).addSailChangedListener((SailChangedListener)this);
    }

    @Test
    public void testNotifyingRemoveAndClear() {
        this.con.begin();
        this.con.addStatement((Resource)this.painter, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.addStatement((Resource)this.picasso, RDF.TYPE, (Value)this.painter, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.guernica, RDF.TYPE, (Value)this.painting, new Resource[]{this.context1});
        this.con.addStatement((Resource)this.picasso, this.paints, (Value)this.guernica, new Resource[]{this.context1});
        this.con.commit();
        this.con.begin();
        this.con.removeStatements((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.countAllElements(), (String)"Repository should contain 4 statements in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.countContext1Elements(), (String)"Named context should contain 3 statements");
        Assertions.assertThat((boolean)this.con.hasStatement((Resource)this.painting, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0])).isFalse();
        this.con.begin();
        this.con.removeStatements(null, null, null, new Resource[]{this.context1});
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.countAllElements(), (String)"Repository should contain 1 statement in total");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countContext1Elements(), (String)"Named context should be empty");
        this.con.begin();
        this.con.clear(new Resource[0]);
        this.con.commit();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.countAllElements(), (String)"Repository should no longer contain any statements");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.addEventCount, (String)"There should have been 1 event in which statements were added");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.removeEventCount, (String)"There should have been 3 events in which statements were removed");
    }

    public void sailChanged(SailChangedEvent event) {
        if (event.statementsAdded()) {
            ++this.addEventCount;
        }
        if (event.statementsRemoved()) {
            ++this.removeEventCount;
        }
    }
}

