/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unique
implements PlanNode {
    private final Logger logger = LoggerFactory.getLogger(Unique.class);
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Unique(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        final Unique that = this;
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<Tuple, SailException> parentIterator;
            Set<Tuple> multiCardinalityDedupeSet;
            boolean useMultiCardinalityDedupeSet;
            Tuple next;
            Tuple previous;
            {
                super(planNode, validationExecutionLogger);
                this.parentIterator = Unique.this.parent.iterator();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    if (temp.line.size() > 1) {
                        this.useMultiCardinalityDedupeSet = true;
                    }
                    if (this.previous == null) {
                        this.next = temp;
                    } else if (this.useMultiCardinalityDedupeSet) {
                        if (this.multiCardinalityDedupeSet == null || !this.previous.line.get(0).equals(temp.line.get(0))) {
                            this.multiCardinalityDedupeSet = new HashSet<Tuple>();
                            if (this.previous.line.get(0).equals(temp.line.get(0))) {
                                this.multiCardinalityDedupeSet.add(this.previous);
                            }
                        }
                        if (!this.multiCardinalityDedupeSet.contains(temp)) {
                            this.next = temp;
                            this.multiCardinalityDedupeSet.add(this.next);
                        }
                    } else if (this.previous != temp && !this.previous.equals(temp)) {
                        this.next = temp;
                    }
                    if (this.next != null) {
                        this.previous = this.next;
                        continue;
                    }
                    if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                    Unique.this.validationExecutionLogger.log(Unique.this.depth(), that.getClass().getSimpleName() + ":IgnoredNotUnique", temp, that, Unique.this.getId());
                }
            }

            public void close() throws SailException {
                this.multiCardinalityDedupeSet = null;
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "Unique";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

