/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.function.Consumer;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class DebugPlanNode
implements PlanNode {
    private StackTraceElement[] stackTrace;
    private Consumer<ValidationTuple> debugPoint;
    private final String message;
    PlanNode parent;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    public DebugPlanNode(PlanNode parent, String message, Consumer<ValidationTuple> debugPoint) {
        this(parent, message);
        this.debugPoint = debugPoint;
    }

    public DebugPlanNode(PlanNode parent, String message) {
        this.parent = parent;
        this.message = message;
    }

    public DebugPlanNode(PlanNode parent, Consumer<ValidationTuple> debugPoint) {
        this(parent, (String)null);
        this.debugPoint = debugPoint;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        if (this.validationExecutionLogger == null && GlobalValidationExecutionLogging.loggingEnabled) {
            throw new IllegalStateException("Did not receive validationExecutionLogger before .iterator() was called!");
        }
        return new CloseableIteration<ValidationTuple, SailException>(){
            final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            {
                this.iterator = DebugPlanNode.this.parent.iterator();
            }

            public boolean hasNext() throws SailException {
                return this.iterator.hasNext();
            }

            public ValidationTuple next() throws SailException {
                ValidationTuple next = (ValidationTuple)this.iterator.next();
                if (DebugPlanNode.this.debugPoint != null) {
                    DebugPlanNode.this.debugPoint.accept(next);
                }
                if (DebugPlanNode.this.message != null && GlobalValidationExecutionLogging.loggingEnabled) {
                    DebugPlanNode.this.validationExecutionLogger.log(DebugPlanNode.this.depth(), DebugPlanNode.this.message, next, DebugPlanNode.this, DebugPlanNode.this.getId(), null);
                }
                return next;
            }

            public void remove() throws SailException {
                this.iterator.remove();
            }

            public void close() throws SailException {
                this.iterator.close();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "DebugPlanNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

