/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class StatementMatcher {
    private final String subjectName;
    private final Resource subjectValue;
    private final String predicateName;
    private final IRI predicateValue;
    private final String objectName;
    private final Value objectValue;
    private final Set<String> varNames;

    public StatementMatcher(String subjectName, Resource subjectValue, String predicateName, IRI predicateValue, String objectName, Value objectValue) {
        this.subjectName = subjectName;
        this.subjectValue = subjectValue;
        this.predicateName = predicateName;
        this.predicateValue = predicateValue;
        this.objectName = objectName;
        this.objectValue = objectValue;
        this.varNames = StatementMatcher.calculateVarNames(subjectName, predicateName, objectName);
    }

    private static Set<String> calculateVarNames(String subjectName, String predicateName, String objectName) {
        if (subjectName != null) {
            if (predicateName != null) {
                if (objectName != null) {
                    return Set.of(subjectName, predicateName, objectName);
                }
                return Set.of(subjectName, predicateName);
            }
            if (objectName != null) {
                return Set.of(subjectName, objectName);
            }
            return Set.of(subjectName);
        }
        if (predicateName != null) {
            if (objectName != null) {
                return Set.of(predicateName, objectName);
            }
            return Set.of(predicateName);
        }
        if (objectName != null) {
            return Set.of(objectName);
        }
        return Set.of();
    }

    public StatementMatcher(Variable subject, Variable predicate, Variable object) {
        this.subjectName = subject == null ? null : subject.name;
        this.subjectValue = subject == null ? null : (Resource)subject.value;
        this.predicateName = predicate == null ? null : predicate.name;
        this.predicateValue = predicate == null ? null : (IRI)predicate.value;
        this.objectName = object == null ? null : object.name;
        this.objectValue = object == null ? null : object.value;
        this.varNames = StatementMatcher.calculateVarNames(this.subjectName, this.predicateName, this.objectName);
    }

    public static List<StatementMatcher> reduce(Set<String> varNames, List<StatementMatcher> statementMatchers) {
        List wildcardMatchers = (statementMatchers = statementMatchers.stream().map(s -> {
            String objectName;
            String predicateName;
            String subjectName = s.subjectName;
            if (subjectName != null && !varNames.contains(subjectName)) {
                subjectName = null;
            }
            if ((predicateName = s.predicateName) != null && !varNames.contains(predicateName)) {
                predicateName = null;
            }
            if ((objectName = s.objectName) != null && !varNames.contains(objectName)) {
                objectName = null;
            }
            return new StatementMatcher(subjectName, s.subjectValue, predicateName, s.predicateValue, objectName, s.objectValue);
        }).collect(Collectors.toList())).stream().filter(s -> s.subjectIsWildcard() || s.predicateIsWildcard() || s.objectIsWildcard()).collect(Collectors.toList());
        if (wildcardMatchers.isEmpty()) {
            return statementMatchers;
        }
        return statementMatchers.stream().filter(s -> {
            for (StatementMatcher statementMatcher : wildcardMatchers) {
                if (statementMatcher == s || !statementMatcher.covers((StatementMatcher)s)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private boolean covers(StatementMatcher s) {
        if (this.subjectIsWildcard()) {
            if (s.subjectName != null) {
                return false;
            }
        } else {
            if (!Objects.equals(this.subjectName, s.subjectName)) {
                return false;
            }
            if (!Objects.equals(this.subjectValue, s.subjectValue)) {
                return false;
            }
        }
        if (this.predicateIsWildcard()) {
            if (s.predicateName != null) {
                return false;
            }
        } else {
            if (!Objects.equals(this.predicateName, s.predicateName)) {
                return false;
            }
            if (!Objects.equals(this.predicateValue, s.predicateValue)) {
                return false;
            }
        }
        if (this.objectIsWildcard()) {
            return s.objectName == null;
        }
        if (!Objects.equals(this.objectName, s.objectName)) {
            return false;
        }
        return Objects.equals(this.objectValue, s.objectValue);
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public Resource getSubjectValue() {
        return this.subjectValue;
    }

    public boolean subjectIsWildcard() {
        return this.subjectName == null && this.subjectValue == null;
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public IRI getPredicateValue() {
        return this.predicateValue;
    }

    public boolean predicateIsWildcard() {
        return this.predicateName == null && this.predicateValue == null;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Value getObjectValue() {
        return this.objectValue;
    }

    public boolean objectIsWildcard() {
        return this.objectName == null && this.objectValue == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementMatcher that = (StatementMatcher)o;
        return Objects.equals(this.subjectName, that.subjectName) && Objects.equals(this.subjectValue, that.subjectValue) && Objects.equals(this.predicateName, that.predicateName) && Objects.equals(this.predicateValue, that.predicateValue) && Objects.equals(this.objectName, that.objectName) && Objects.equals(this.objectValue, that.objectValue);
    }

    public int hashCode() {
        return Objects.hash(this.subjectName, this.subjectValue, this.predicateName, this.predicateValue, this.objectName, this.objectValue);
    }

    public String getSparqlValuesDecl() {
        StringBuilder sb = new StringBuilder("VALUES ( ");
        if (this.subjectName != null) {
            sb.append("?").append(this.subjectName).append(" ");
        }
        if (this.predicateName != null) {
            sb.append("?").append(this.predicateName).append(" ");
        }
        if (this.objectName != null) {
            sb.append("?").append(this.objectName).append(" ");
        }
        sb.append("){}\n");
        return sb.toString();
    }

    public Set<String> getVarNames() {
        return this.varNames;
    }

    public String toString() {
        return "StatementMatcher{ " + StatementMatcher.formatForToString("s", this.subjectName, (Value)this.subjectValue) + ", " + StatementMatcher.formatForToString("p", this.predicateName, (Value)this.predicateValue) + ", " + StatementMatcher.formatForToString("o", this.objectName, this.objectValue) + " }";
    }

    private static String formatForToString(String field, String name, Value value) {
        if (value == null && name == null) {
            return field + "[*]";
        }
        StringBuilder ret = new StringBuilder(field).append("[");
        if (name != null) {
            ret.append("\"").append(name).append("\"").append("=");
        }
        if (value == null) {
            ret.append("*");
        } else if (value.isIRI()) {
            IRI iri = (IRI)value;
            if (iri.getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                ret.append("rdf:").append(iri.getLocalName());
            } else if (iri.getNamespace().equals("http://www.w3.org/ns/shacl#")) {
                ret.append("sh:").append(iri.getLocalName());
            } else if (iri.getNamespace().equals("http://www.w3.org/2000/01/rdf-schema#")) {
                ret.append("rdfs:").append(iri.getLocalName());
            } else {
                ret.append("<").append(iri).append(">");
            }
        } else {
            ret.append(value);
        }
        return ret.append("]").toString();
    }

    public static class Variable {
        public static final Variable VALUE = new Variable("value");
        String name;
        Value value;

        public Variable(String name, Value value) {
            this.name = name;
            this.value = value;
        }

        public Variable(String name) {
            this.name = name;
        }

        public Variable(Value value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue() {
            return this.value;
        }

        public boolean isWildcard() {
            return this.name == null && this.value == null;
        }

        public String asSparqlVariable() {
            if (this.value != null) {
                throw new IllegalStateException("Can not produce SPARQL variable for variables that have fixed values!");
            }
            return "?" + this.name.replace("-", "__");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.name, variable.name) && Objects.equals(this.value, variable.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Variable{name='" + this.name + "', value=" + this.value + "}";
        }
    }

    public static class StableRandomVariableProvider {
        private static final String BASE = UUID.randomUUID().toString().replace("-", "") + "_";
        private final String prefix;
        private static volatile int max = 0;
        private int counter = -1;

        public Variable next() {
            ++this.counter;
            if (this.counter > max) {
                max = this.counter;
            }
            return this.current();
        }

        public Variable current() {
            if (this.counter < 0) {
                throw new IllegalStateException("next() has not been called");
            }
            return new Variable(this.prefix + BASE + this.counter + "_");
        }

        public StableRandomVariableProvider() {
            this.prefix = "";
        }

        public StableRandomVariableProvider(String prefix) {
            this.prefix = prefix;
        }

        public static String normalize(String inputQuery) {
            int max;
            if (!inputQuery.contains(BASE)) {
                return inputQuery;
            }
            int lowest = max = Math.min(100, StableRandomVariableProvider.max);
            int highest = 0;
            boolean incrementsOfOne = true;
            int prev = -1;
            for (int i = 0; i <= max; ++i) {
                if (!inputQuery.contains(BASE + i + "_")) continue;
                lowest = Math.min(lowest, i);
                highest = Math.max(highest, i);
                if (prev >= 0 && prev + 1 != i) {
                    incrementsOfOne = false;
                }
                prev = i;
            }
            if (lowest == 0 && incrementsOfOne) {
                return inputQuery;
            }
            return StableRandomVariableProvider.normalizeRange(inputQuery, lowest, highest);
        }

        private static String normalizeRange(String inputQuery, int lowest, int highest) {
            String normalizedQuery = inputQuery;
            block0: for (int i = 0; i <= highest; ++i) {
                if (normalizedQuery.contains(BASE + i + "_")) continue;
                for (int j = Math.max(i + 1, lowest); j <= highest; ++j) {
                    if (!normalizedQuery.contains(BASE + j + "_")) continue;
                    normalizedQuery = normalizedQuery.replace(BASE + j + "_", BASE + i + "_");
                    continue block0;
                }
            }
            return normalizedQuery;
        }
    }
}

