/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

@InternalUseOnly
public class ShaclSailValidationReportHelper {
    private static final WriterConfig WRITER_CONFIG = new WriterConfig();

    public static Optional<String> getValidationReportAsString(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ShaclSailValidationReportHelper.printValidationReport(t, baos);
        String reportAsString = baos.toString();
        if (reportAsString == null || reportAsString.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(reportAsString);
    }

    public static void printValidationReport(Throwable t, OutputStream out) {
        Optional<Model> reportOpt = ShaclSailValidationReportHelper.getValidationReport(t);
        if (reportOpt.isPresent()) {
            Rio.write((Iterable)((Iterable)reportOpt.get()), (OutputStream)out, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)WRITER_CONFIG);
        }
    }

    public static Optional<Model> getValidationReport(Throwable t) {
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof ValidationException)) continue;
            return Optional.ofNullable(((ValidationException)throwable).validationReportAsModel());
        }
        return Optional.empty();
    }

    static {
        WRITER_CONFIG.set(BasicWriterSettings.PRETTY_PRINT, (Object)true).set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
    }
}

