/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShape;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclShapeParsingException;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AndConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ClassConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ClosedConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DashHasValueInConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DatatypeConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.DisjointConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.EqualsConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.HasValueConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.InConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LanguageInConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LessThanConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LessThanOrEqualsConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxExclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxInclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MaxLengthConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinExclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinInclusiveConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.MinLengthConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NodeKindConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.NotConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.OrConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.PatternConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.QualifiedMaxCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.QualifiedMinCountConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SparqlConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.UniqueLangConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.XoneConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingleCloseablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.DashAllObjects;
import org.eclipse.rdf4j.sail.shacl.ast.targets.DashAllSubjects;
import org.eclipse.rdf4j.sail.shacl.ast.targets.RSXTargetShape;
import org.eclipse.rdf4j.sail.shacl.ast.targets.SparqlTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetObjectsOf;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetSubjectsOf;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Shape
implements ConstraintComponent,
Identifiable {
    private static final Logger logger = LoggerFactory.getLogger(Shape.class);
    protected boolean produceValidationReports;
    Resource id;
    TargetChain targetChain;
    List<Target> target = new ArrayList<Target>();
    boolean deactivated;
    List<Literal> message;
    Severity severity;
    List<ConstraintComponent> constraintComponents = new ArrayList<ConstraintComponent>();
    Resource[] contexts;

    public Shape() {
    }

    public Shape(Shape shape) {
        this.deactivated = shape.deactivated;
        this.message = shape.message;
        this.severity = shape.severity;
        this.id = shape.id;
        this.targetChain = shape.targetChain;
        this.contexts = shape.contexts;
        this.produceValidationReports = shape.produceValidationReports;
    }

    public void populate(ShaclProperties properties, ShapeSource shapeSource, ParseSettings parseSettings, Cache cache) {
        this.deactivated = properties.isDeactivated();
        this.message = properties.getMessage();
        this.id = properties.getId();
        this.contexts = shapeSource.getActiveContexts();
        this.severity = Severity.fromIri(properties.getSeverity());
        if (!properties.getTargetClass().isEmpty()) {
            this.target.add(new TargetClass(properties.getTargetClass()));
        }
        if (!properties.getTargetNode().isEmpty()) {
            this.target.add(new TargetNode(properties.getTargetNode(), shapeSource.getActiveContexts()));
        }
        if (!properties.getTargetObjectsOf().isEmpty()) {
            this.target.add(new TargetObjectsOf(properties.getTargetObjectsOf()));
        }
        if (!properties.getTargetSubjectsOf().isEmpty()) {
            this.target.add(new TargetSubjectsOf(properties.getTargetSubjectsOf()));
        }
        if (parseSettings.parseEclipseRdf4jShaclExtensions() && !properties.getTargetShape().isEmpty()) {
            properties.getTargetShape().stream().map(targetShape -> new RSXTargetShape((Resource)targetShape, shapeSource, parseSettings)).forEach(this.target::add);
        }
        if (!properties.getTarget().isEmpty()) {
            properties.getTarget().forEach(target -> {
                if (shapeSource.isType((Resource)target, SHACL.SPARQL_TARGET)) {
                    this.target.add(new SparqlTarget((Resource)target, shapeSource));
                }
                if (parseSettings.parseDashDataShapes() && shapeSource.isType((Resource)target, DASH.AllObjectsTarget)) {
                    this.target.add(new DashAllObjects((Resource)target));
                }
                if (parseSettings.parseDashDataShapes() && shapeSource.isType((Resource)target, DASH.AllSubjectsTarget)) {
                    this.target.add(new DashAllSubjects((Resource)target));
                }
            });
        }
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public Resource[] getContexts() {
        return this.contexts;
    }

    protected abstract Shape shallowClone();

    public Model toModel(Model model) {
        this.toModel(null, null, model, new HashSet<Resource>());
        return model;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.subject(this.getId());
        if (this.deactivated) {
            modelBuilder.add(SHACL.DEACTIVATED, (Object)this.deactivated);
        }
        for (Literal literal : this.message) {
            modelBuilder.add(SHACL.MESSAGE, (Object)literal);
        }
        this.target.forEach(t -> t.toModel(this.getId(), null, model, cycleDetection));
        if (this.severity != null) {
            modelBuilder.add(SHACL.SEVERITY_PROP, (Object)this.severity.getIri());
        }
        model.addAll((Collection)modelBuilder.build());
    }

    List<ConstraintComponent> getConstraintComponents(ShaclProperties properties, ShapeSource shapeSource, ParseSettings parseSettings, Cache cache) {
        Shape instance;
        ShaclProperties shaclProperties;
        ArrayList<ConstraintComponent> constraintComponent = new ArrayList<ConstraintComponent>();
        for (Resource resource : properties.getProperty()) {
            shaclProperties = new ShaclProperties(resource, shapeSource);
            instance = PropertyShape.getInstance(shaclProperties, shapeSource, parseSettings, cache);
            constraintComponent.add(instance);
        }
        for (Resource r : properties.getNode()) {
            shaclProperties = new ShaclProperties(r, shapeSource);
            instance = NodeShape.getInstance(shaclProperties, shapeSource, parseSettings, cache);
            constraintComponent.add(instance);
        }
        if (properties.getMinCount() != null) {
            constraintComponent.add(new MinCountConstraintComponent(properties.getMinCount()));
        }
        if (properties.getMaxCount() != null) {
            constraintComponent.add(new MaxCountConstraintComponent(properties.getMaxCount()));
        }
        if (properties.getDatatype() != null) {
            constraintComponent.add(new DatatypeConstraintComponent(properties.getDatatype()));
        }
        if (properties.getMinLength() != null) {
            constraintComponent.add(new MinLengthConstraintComponent(properties.getMinLength()));
        }
        if (properties.getMaxLength() != null) {
            constraintComponent.add(new MaxLengthConstraintComponent(properties.getMaxLength()));
        }
        if (properties.getMinInclusive() != null) {
            constraintComponent.add(new MinInclusiveConstraintComponent(properties.getMinInclusive()));
        }
        if (properties.getMaxInclusive() != null) {
            constraintComponent.add(new MaxInclusiveConstraintComponent(properties.getMaxInclusive()));
        }
        if (properties.getMinExclusive() != null) {
            constraintComponent.add(new MinExclusiveConstraintComponent(properties.getMinExclusive()));
        }
        if (properties.getMaxExclusive() != null) {
            constraintComponent.add(new MaxExclusiveConstraintComponent(properties.getMaxExclusive()));
        }
        if (properties.isUniqueLang()) {
            constraintComponent.add(new UniqueLangConstraintComponent());
        }
        if (properties.getPattern() != null) {
            Iterator<Value> patternConstraintComponent = new PatternConstraintComponent(properties.getPattern(), properties.getFlags());
            constraintComponent.add((ConstraintComponent)((Object)patternConstraintComponent));
        }
        if (properties.getLanguageIn() != null) {
            constraintComponent.add(new LanguageInConstraintComponent(shapeSource, properties.getLanguageIn()));
        }
        if (properties.getIn() != null) {
            constraintComponent.add(new InConstraintComponent(shapeSource, properties.getIn()));
        }
        if (properties.getNodeKind() != null) {
            constraintComponent.add(new NodeKindConstraintComponent(properties.getNodeKind()));
        }
        if (properties.isClosed()) {
            constraintComponent.add(new ClosedConstraintComponent(shapeSource, properties.getProperty(), properties.getIgnoredProperties()));
        }
        for (IRI iri : properties.getClazz()) {
            ClassConstraintComponent classConstraintComponent = new ClassConstraintComponent(iri);
            constraintComponent.add(classConstraintComponent);
        }
        for (Value value : properties.getHasValue()) {
            HasValueConstraintComponent hasValueConstraintComponent = new HasValueConstraintComponent(value);
            constraintComponent.add(hasValueConstraintComponent);
        }
        for (IRI iri : properties.getEquals()) {
            EqualsConstraintComponent equalsConstraintComponent = new EqualsConstraintComponent(iri);
            constraintComponent.add(equalsConstraintComponent);
        }
        for (IRI iri : properties.getDisjoint()) {
            DisjointConstraintComponent disjointConstraintComponent = new DisjointConstraintComponent(iri);
            constraintComponent.add(disjointConstraintComponent);
        }
        for (IRI iri : properties.getLessThan()) {
            LessThanConstraintComponent lessThanConstraintComponent = new LessThanConstraintComponent(iri);
            constraintComponent.add(lessThanConstraintComponent);
        }
        for (IRI iri : properties.getLessThanOrEquals()) {
            LessThanOrEqualsConstraintComponent lessThanOrEqualsConstraintComponent = new LessThanOrEqualsConstraintComponent(iri);
            constraintComponent.add(lessThanOrEqualsConstraintComponent);
        }
        if (properties.getQualifiedValueShape() != null) {
            if (properties.getQualifiedMaxCount() != null) {
                QualifiedMaxCountConstraintComponent qualifiedMaxCountConstraintComponent = new QualifiedMaxCountConstraintComponent(properties.getQualifiedValueShape(), shapeSource, parseSettings, cache, properties.getQualifiedValueShapesDisjoint(), properties.getQualifiedMaxCount());
                constraintComponent.add(qualifiedMaxCountConstraintComponent);
            }
            if (properties.getQualifiedMinCount() != null) {
                QualifiedMinCountConstraintComponent qualifiedMinCountConstraintComponent = new QualifiedMinCountConstraintComponent(properties.getQualifiedValueShape(), shapeSource, parseSettings, cache, properties.getQualifiedValueShapesDisjoint(), properties.getQualifiedMinCount());
                constraintComponent.add(qualifiedMinCountConstraintComponent);
            }
        }
        if (parseSettings.parseDashDataShapes()) {
            for (Resource hasValueIn : properties.getHasValueIn()) {
                DashHasValueInConstraintComponent dashHasValueInConstraintComponent = new DashHasValueInConstraintComponent(shapeSource, hasValueIn);
                constraintComponent.add(dashHasValueInConstraintComponent);
            }
        }
        for (Resource resource : properties.getOr()) {
            OrConstraintComponent orConstraintComponent = new OrConstraintComponent(resource, shapeSource, parseSettings, cache);
            constraintComponent.add(orConstraintComponent);
        }
        for (Resource xone : properties.getXone()) {
            XoneConstraintComponent xoneConstraintComponent = new XoneConstraintComponent(xone, shapeSource, parseSettings, cache);
            constraintComponent.add(xoneConstraintComponent);
        }
        for (Resource and : properties.getAnd()) {
            AndConstraintComponent andConstraintComponent = new AndConstraintComponent(and, shapeSource, parseSettings, cache);
            constraintComponent.add(andConstraintComponent);
        }
        for (Resource or : properties.getNot()) {
            NotConstraintComponent notConstraintComponent = new NotConstraintComponent(or, shapeSource, parseSettings, cache);
            constraintComponent.add(notConstraintComponent);
        }
        for (Resource resource : properties.getSparql()) {
            SparqlConstraintComponent component = new SparqlConstraintComponent(resource, shapeSource, this);
            constraintComponent.add(component);
        }
        return constraintComponent;
    }

    @Override
    public TargetChain getTargetChain() {
        return this.targetChain;
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        this.targetChain = targetChain;
        this.constraintComponents.forEach(c -> c.setTargetChain(targetChain));
    }

    public PlanNode generatePlans(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings) {
        try {
            assert (this.constraintComponents.size() == 1);
            StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
            ValidationApproach validationApproach = ValidationApproach.SPARQL;
            if (!validationSettings.isValidateEntireBaseSail()) {
                validationApproach = this.constraintComponents.stream().map(constraintComponent -> constraintComponent.getPreferredValidationApproach(connectionsGroup)).reduce(ValidationApproach::reducePreferred).get();
            }
            if (validationApproach == ValidationApproach.SPARQL) {
                if (connectionsGroup.isSparqlValidation() && this.getOptimalBulkValidationApproach() == ValidationApproach.SPARQL) {
                    logger.debug("Use validation approach {} for shape {}", (Object)validationApproach, (Object)this);
                    return new SingleCloseablePlanNode(this.generateSparqlValidationQuery(connectionsGroup, validationSettings, false, false, ConstraintComponent.Scope.none).getValidationPlan(connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getContexts()), this);
                }
                logger.debug("Use fall back validation approach for bulk validation instead of SPARQL for shape {}", (Object)this);
                return new SingleCloseablePlanNode(this.generateTransactionalValidationPlan(connectionsGroup, validationSettings, () -> this.getTargetChain().getEffectiveTarget(this instanceof NodeShape ? ConstraintComponent.Scope.nodeShape : ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getAllTargets(connectionsGroup, validationSettings.getDataGraph(), this instanceof NodeShape ? ConstraintComponent.Scope.nodeShape : ConstraintComponent.Scope.propertyShape), ConstraintComponent.Scope.none), this);
            }
            if (validationApproach == ValidationApproach.Transactional) {
                logger.debug("Use validation approach {} for shape {}", (Object)validationApproach, (Object)this);
                if (this.requiresEvaluation(connectionsGroup, ConstraintComponent.Scope.none, validationSettings.getDataGraph(), stableRandomVariableProvider)) {
                    return new SingleCloseablePlanNode(this.generateTransactionalValidationPlan(connectionsGroup, validationSettings, null, ConstraintComponent.Scope.none), this);
                }
                return EmptyNode.getInstance();
            }
            throw new ShaclUnsupportedException("Unkown validation approach: " + validationApproach);
        }
        catch (RuntimeException e) {
            throw new SailException("Error processing SHACL Shape " + this.id + "\n" + this, (Throwable)e);
        }
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        throw new ShaclUnsupportedException(this.getClass().getSimpleName());
    }

    public Severity getSeverity() {
        return Severity.orDefault(this.severity);
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        for (ConstraintComponent c : this.constraintComponents) {
            if (!c.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable<Value> subject, StatementMatcher.Variable<Value> object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return this.constraintComponents.stream().map(ConstraintComponent::getOptimalBulkValidationApproach).reduce(ValidationApproach::reduceCompatible).orElse(ValidationApproach.MOST_COMPATIBLE);
    }

    public final List<Literal> getMessage() {
        if (this.message.isEmpty()) {
            return this.getDefaultMessage();
        }
        return this.message;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return this.constraintComponents.stream().map(ConstraintComponent::getDefaultMessage).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Shape)) {
            return false;
        }
        Shape shape = (Shape)o;
        if (this.produceValidationReports != shape.produceValidationReports) {
            return false;
        }
        if (this.deactivated != shape.deactivated) {
            return false;
        }
        if (!Objects.equals(this.target, shape.target)) {
            return false;
        }
        if (!Objects.equals(this.message, shape.message)) {
            return false;
        }
        if (this.severity != shape.severity) {
            return false;
        }
        return Objects.equals(this.constraintComponents, shape.constraintComponents);
    }

    public int hashCode() {
        int result = this.produceValidationReports ? 1 : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.deactivated ? 1 : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
        result = 31 * result + (this.constraintComponents != null ? this.constraintComponents.hashCode() : 0);
        return result;
    }

    public String toString() {
        Model statements = this.toModel((Model)new DynamicModel((ModelFactory)new LinkedHashModelFactory()));
        statements.setNamespace(SHACL.NS);
        statements.setNamespace(XSD.NS);
        statements.setNamespace(RSX.NS);
        statements.setNamespace(RDFS.NS);
        statements.setNamespace(RDF.NS);
        WriterConfig writerConfig = new WriterConfig().set(BasicWriterSettings.PRETTY_PRINT, (Object)true).set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        StringWriter stringWriter = new StringWriter();
        Rio.write((Iterable)statements, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)writerConfig);
        return stringWriter.toString().replaceAll("(?m)^(@prefix)(.*)(\\.)$", "").trim();
    }

    @InternalUseOnly
    public static class ParseSettings {
        private final boolean eclipseRdf4jShaclExtensions;
        private final boolean dashDataShapes;

        public ParseSettings(boolean eclipseRdf4jShaclExtensions, boolean dashDataShapes) {
            this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
            this.dashDataShapes = dashDataShapes;
        }

        public boolean parseEclipseRdf4jShaclExtensions() {
            return this.eclipseRdf4jShaclExtensions;
        }

        public boolean parseDashDataShapes() {
            return this.dashDataShapes;
        }
    }

    public static class Factory {
        public static List<ContextWithShape> getShapes(ShapeSource shapeSource, ParseSettings parseSettings) {
            List<ContextWithShape> parsed = Factory.parse(shapeSource, parseSettings);
            return Factory.getShapes(parsed);
        }

        public static List<ContextWithShape> getShapes(List<ContextWithShape> parsed) {
            return parsed.stream().flatMap(contextWithShapes -> {
                List<Shape> split = Factory.split(contextWithShapes.getShape());
                Factory.calculateTargetChain(split);
                Factory.calculateIfProducesValidationResult(split);
                return split.stream().map(s -> new ContextWithShape(contextWithShapes.getDataGraph(), contextWithShapes.getShapeGraph(), (Shape)s));
            }).filter(ContextWithShape::hasShape).distinct().collect(Collectors.toList());
        }

        private static void calculateIfProducesValidationResult(List<Shape> split) {
            for (Shape shape : split) {
                assert (shape.constraintComponents.size() == 1);
                if (shape instanceof PropertyShape || shape.constraintComponents.get(0) instanceof PropertyShape) {
                    PropertyShape propertyShape = shape instanceof PropertyShape ? (PropertyShape)shape : (PropertyShape)shape.constraintComponents.get(0);
                    while (propertyShape.constraintComponents.get(0) instanceof PropertyShape) {
                        assert (propertyShape.constraintComponents.size() == 1);
                        if (!(propertyShape.constraintComponents.get(0) instanceof PropertyShape)) continue;
                        propertyShape = (PropertyShape)propertyShape.constraintComponents.get(0);
                    }
                    propertyShape.produceValidationReports = true;
                    continue;
                }
                if (!(shape instanceof NodeShape)) continue;
                if (shape.constraintComponents.get(0) instanceof SparqlConstraintComponent) {
                    ((SparqlConstraintComponent)shape.constraintComponents.get((int)0)).produceValidationReports = true;
                    continue;
                }
                shape.produceValidationReports = true;
            }
        }

        private static void calculateTargetChain(List<Shape> parsed) {
            for (Shape shape : parsed) {
                assert (shape.target.size() == 1);
                shape.setTargetChain(new TargetChain().add(shape.target.get(0)));
            }
        }

        private static List<Shape> split(Shape s) {
            ArrayList<Shape> temp = new ArrayList<Shape>();
            s.target.forEach(target -> s.constraintComponents.forEach(constraintComponent -> {
                if (constraintComponent instanceof PropertyShape) {
                    List split = Factory.splitPropertyShape((PropertyShape)constraintComponent).collect(Collectors.toList());
                    for (PropertyShape propertyShape : split) {
                        Shape shape = s.shallowClone();
                        shape.target.add((Target)target);
                        shape.constraintComponents.add(propertyShape);
                        temp.add(shape);
                    }
                } else {
                    Shape shape = s.shallowClone();
                    shape.target.add((Target)target);
                    shape.constraintComponents.add((ConstraintComponent)constraintComponent);
                    temp.add(shape);
                }
            }));
            return temp;
        }

        private static Stream<PropertyShape> splitPropertyShape(PropertyShape propertyShape) {
            return propertyShape.constraintComponents.stream().flatMap(constraintComponent -> {
                if (constraintComponent instanceof PropertyShape) {
                    return Factory.splitPropertyShape((PropertyShape)constraintComponent).map(splitConstraintComponent -> {
                        PropertyShape propertyShapeClone = (PropertyShape)propertyShape.shallowClone();
                        propertyShapeClone.constraintComponents.add(splitConstraintComponent);
                        return propertyShapeClone;
                    });
                }
                PropertyShape propertyShapeClone = (PropertyShape)propertyShape.shallowClone();
                propertyShapeClone.constraintComponents.add(constraintComponent.deepClone());
                return Stream.of(propertyShapeClone);
            });
        }

        public static List<ContextWithShape> parse(ShapeSource shapeSource, ParseSettings parseSettings) {
            try (Stream<ShapeSource.ShapesGraph> allShapeContexts = shapeSource.getAllShapeContexts();){
                List<ContextWithShape> list = allShapeContexts.map(shapesGraph -> Factory.parse(shapeSource, shapesGraph, parseSettings)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                return list;
            }
        }

        public static List<ContextWithShape> parse(ShapeSource shapeSource, ShapeSource.ShapesGraph shapesGraph, ParseSettings parseSettings) {
            Cache cache = new Cache();
            return Factory.getShapesInContext(shapeSource, parseSettings, cache, shapesGraph.getDataGraph(), shapesGraph.getShapesGraph());
        }

        public static List<ContextWithShape> getShapesInContext(ShapeSource shapeSource, ParseSettings parseSettings, Cache cache, Resource[] dataGraph, Resource[] shapesGraph) {
            ShapeSource shapeSourceWithContext = shapeSource.withContext(shapesGraph);
            try (Stream<Resource> resources = shapeSourceWithContext.getTargetableShape();){
                List<ContextWithShape> list = resources.map(r -> {
                    try {
                        return new ShaclProperties((Resource)r, shapeSourceWithContext);
                    }
                    catch (Exception e) {
                        throw new ShaclShapeParsingException(e, (Resource)r);
                    }
                }).map(p -> {
                    try {
                        if (p.getType() == SHACL.NODE_SHAPE) {
                            return NodeShape.getInstance(p, shapeSourceWithContext, parseSettings, cache);
                        }
                        if (p.getType() == SHACL.PROPERTY_SHAPE) {
                            return PropertyShape.getInstance(p, shapeSourceWithContext, parseSettings, cache);
                        }
                        throw new ShaclShapeParsingException("Unknown shape type", p.getId());
                    }
                    catch (Exception e) {
                        if (e instanceof ShaclShapeParsingException) {
                            throw e;
                        }
                        throw new ShaclShapeParsingException(e, p.getId());
                    }
                }).map(shape -> new ContextWithShape(dataGraph, shapesGraph, (Shape)shape)).filter(ContextWithShape::hasShape).collect(Collectors.toList());
                return list;
            }
        }
    }
}

