/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLComplianceTest {
    private static final Logger logger = LoggerFactory.getLogger(SPARQLComplianceTest.class);
    private List<String> ignoredTests = new ArrayList<String>();
    private final String displayName;
    private final String testURI;
    private final String name;

    public SPARQLComplianceTest(String displayName, String testURI, String name) {
        this.displayName = displayName;
        this.testURI = testURI;
        this.name = name;
    }

    @Test
    public void test() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getIgnoredTests().contains(this.getName())).withFailMessage("test case '%s' is ignored", new Object[]{this.getName()})).isFalse();
        this.runTest();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTestURI() {
        return this.testURI;
    }

    public String getName() {
        return this.name;
    }

    protected abstract void runTest() throws Exception;

    protected abstract Repository getDataRepository();

    protected static boolean includeSubManifest(String subManifestFile, List<String> excludedSubdirs) {
        boolean result = true;
        if (excludedSubdirs != null && !excludedSubdirs.isEmpty()) {
            int index = subManifestFile.lastIndexOf(47);
            String path = subManifestFile.substring(0, index);
            String sd = path.substring(path.lastIndexOf(47) + 1);
            for (String subdir : excludedSubdirs) {
                if (!sd.equals(subdir)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected void uploadDataset(Dataset dataset) throws Exception {
        try (RepositoryConnection con = this.getDataRepository().getConnection();){
            HashSet graphURIs = new HashSet();
            graphURIs.addAll(dataset.getDefaultGraphs());
            graphURIs.addAll(dataset.getNamedGraphs());
            for (Resource graphURI : graphURIs) {
                this.upload((IRI)graphURI, graphURI);
            }
        }
    }

    protected void upload(IRI graphURI, Resource context) throws Exception {
        try (RepositoryConnection con = this.getDataRepository().getConnection();){
            con.begin();
            RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)graphURI.toString()).orElse(RDFFormat.TURTLE);
            RDFParser rdfParser = Rio.createParser((RDFFormat)rdfFormat, (ValueFactory)this.getDataRepository().getValueFactory());
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(new Resource[]{context});
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            URL graphURL = new URL(graphURI.toString());
            try (InputStream in = graphURL.openStream();){
                rdfParser.parse(in, graphURI.toString());
            }
            con.commit();
        }
    }

    protected static final void printBindingSet(BindingSet bs, StringBuilder appendable) {
        ArrayList names = new ArrayList(bs.getBindingNames());
        Collections.sort(names);
        for (String name : names) {
            if (!bs.hasBinding(name)) continue;
            appendable.append(bs.getBinding(name));
            appendable.append(' ');
        }
        appendable.append("\n");
    }

    protected List<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    protected void addIgnoredTest(String ignoredTest) {
        this.ignoredTests.add(ignoredTest);
    }

    protected void setIgnoredTests(List<String> ignoredTests) {
        this.ignoredTests = ignoredTests;
    }

    protected void compareGraphs(Iterable<Statement> queryResult, Iterable<Statement> expectedResult) throws Exception {
        if (!Models.isomorphic(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement st : expectedResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Query result: \n");
            for (Statement st : queryResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            logger.error(message.toString());
            Assertions.fail((String)message.toString());
        }
    }
}

