/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class UnionTest
extends AbstractComplianceTest {
    @Test
    public void testEmptyUnion() {
        String query = "PREFIX : <http://example.org/> SELECT ?visibility WHERE {OPTIONAL { SELECT ?var WHERE { :s a :MyType . BIND (:s as ?var ) .} } .BIND (IF(BOUND(?var), 'VISIBLE', 'HIDDEN') as ?visibility)}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSameTermRepeatInUnion() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = "PREFIX foaf:<http://xmlns.com/foaf/0.1/>\nSELECT * {\n    {\n        ?sameTerm foaf:mbox ?mbox\n        FILTER sameTerm(?sameTerm,$william)\n    } UNION {\n        ?x foaf:knows ?sameTerm\n        FILTER sameTerm(?sameTerm,$william)\n    }\n}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        tq.setBinding("william", (Value)this.conn.getValueFactory().createIRI("http://example.org/william"));
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value mbox = bs.getValue("mbox");
                Value x = bs.getValue("x");
                Assert.assertTrue((mbox instanceof Literal || x instanceof IRI ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)3L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInUnionAndOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT * {\n    {\n        ex:a ?p ?prop1\n        FILTER (?p = ex:prop1)\n    } UNION {\n          ?s ex:p ex:A ;           {               {                  ?s ?p ?l .                 FILTER(?p = rdfs:label)               }               OPTIONAL {                  ?s ?p ?opt1 .                  FILTER (?p = ex:prop1)               }               OPTIONAL {                  ?s ?p ?opt2 .                  FILTER (?p = ex:prop2)               }           }    }\n}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value prop1 = bs.getValue("prop1");
                Value l = bs.getValue("l");
                Assert.assertTrue((prop1 instanceof Literal || l instanceof Literal ? 1 : 0) != 0);
                if (!(l instanceof Literal)) continue;
                Value opt1 = bs.getValue("opt1");
                Assert.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                Assert.assertNull((Object)opt2);
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

