/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComplianceTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Supplier<Repository> repo;

    protected DynamicTest makeTest(String name, ThrowingConsumer<RepositoryConnection> x) {
        Executable e = () -> {
            Repository repo = this.openRepository();
            try (RepositoryConnection conn = repo.getConnection();){
                x.accept((Object)conn);
            }
            finally {
                this.closeRepository(repo);
            }
        };
        return DynamicTest.dynamicTest((String)name, (Executable)e);
    }

    protected Repository openRepository() {
        Repository r = this.repo.get();
        r.init();
        return r;
    }

    protected RepositoryConnection openConnection(Repository r) {
        return new RepositoryConnectionWrapper(r.getConnection());
    }

    protected void closeRepository(Repository r) {
        try (RepositoryConnection conn = r.getConnection();){
            conn.clear(new Resource[0]);
        }
        r.shutDown();
    }

    public AbstractComplianceTest(Supplier<Repository> repo) {
        this.repo = repo;
    }

    protected void loadTestData(String dataFile, RepositoryConnection conn, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        this.logger.debug("loading dataset {}", (Object)dataFile);
        try (InputStream dataset = this.getClass().getResourceAsStream(dataFile);){
            conn.add(dataset, "", (RDFFormat)Rio.getParserFormatForFileName((String)dataFile).orElseThrow(Rio.unsupportedFormat((String)dataFile)), contexts);
        }
        this.logger.debug("dataset loaded.");
    }

    protected String getNamespaceDeclarations() {
        return "PREFIX dc: <http://purl.org/dc/terms/> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX ex: <http://example.org/> \n\n";
    }

    private static class RepositoryConnectionWrapper
    implements RepositoryConnection {
        private final RepositoryConnection delegate;

        public RepositoryConnectionWrapper(RepositoryConnection delegate) {
            this.delegate = delegate;
        }

        public Repository getRepository() {
            return this.delegate.getRepository();
        }

        public void setParserConfig(ParserConfig config) {
            this.delegate.setParserConfig(config);
        }

        public ParserConfig getParserConfig() {
            return this.delegate.getParserConfig();
        }

        public ValueFactory getValueFactory() {
            return this.delegate.getValueFactory();
        }

        public boolean isOpen() throws RepositoryException {
            return this.delegate.isOpen();
        }

        public void close() throws RepositoryException {
            this.delegate.close();
        }

        private <T> T checkThatHashCodeWorks(T prepareQuery) {
            assert (prepareQuery.hashCode() == prepareQuery.hashCode());
            assert (prepareQuery.hashCode() != System.identityHashCode(prepareQuery));
            return prepareQuery;
        }

        public Query prepareQuery(String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareQuery(query));
        }

        public Query prepareQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareQuery(ql, query));
        }

        public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareQuery(ql, query, baseURI));
        }

        public TupleQuery prepareTupleQuery(String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareTupleQuery(query));
        }

        public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareTupleQuery(ql, query));
        }

        public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareTupleQuery(ql, query, baseURI));
        }

        public GraphQuery prepareGraphQuery(String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareGraphQuery(query));
        }

        public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareGraphQuery(ql, query));
        }

        public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareGraphQuery(ql, query, baseURI));
        }

        public BooleanQuery prepareBooleanQuery(String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareBooleanQuery(query));
        }

        public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareBooleanQuery(ql, query));
        }

        public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareBooleanQuery(ql, query, baseURI));
        }

        public Update prepareUpdate(String update) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareUpdate(update));
        }

        public Update prepareUpdate(QueryLanguage ql, String update) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareUpdate(ql, update));
        }

        public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
            return this.checkThatHashCodeWorks(this.delegate.prepareUpdate(ql, update, baseURI));
        }

        public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
            return this.delegate.getContextIDs();
        }

        public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
            return this.delegate.getStatements(subj, pred, obj, contexts);
        }

        public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
            return this.delegate.getStatements(subj, pred, obj, includeInferred, contexts);
        }

        public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
            return this.delegate.hasStatement(subj, pred, obj, includeInferred, contexts);
        }

        public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
            return this.delegate.hasStatement(st, includeInferred, contexts);
        }

        public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
            this.delegate.exportStatements(subj, pred, obj, includeInferred, handler, contexts);
        }

        public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
            this.delegate.export(handler, contexts);
        }

        public long size(Resource ... contexts) throws RepositoryException {
            return this.delegate.size(contexts);
        }

        public boolean isEmpty() throws RepositoryException {
            return this.delegate.isEmpty();
        }

        @Deprecated
        public void setAutoCommit(boolean autoCommit) throws RepositoryException {
            this.delegate.setAutoCommit(autoCommit);
        }

        @Deprecated
        public boolean isAutoCommit() throws RepositoryException {
            return this.delegate.isAutoCommit();
        }

        public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
            return this.delegate.isActive();
        }

        public void setIsolationLevel(IsolationLevel level) throws IllegalStateException {
            this.delegate.setIsolationLevel(level);
        }

        public IsolationLevel getIsolationLevel() {
            return this.delegate.getIsolationLevel();
        }

        public void begin() throws RepositoryException {
            this.delegate.begin();
        }

        public void begin(IsolationLevel level) throws RepositoryException {
            this.delegate.begin(level);
        }

        public void begin(TransactionSetting ... settings) {
            this.delegate.begin(settings);
        }

        public void prepare() throws RepositoryException {
            this.delegate.prepare();
        }

        public void commit() throws RepositoryException {
            this.delegate.commit();
        }

        public void rollback() throws RepositoryException {
            this.delegate.rollback();
        }

        public void add(InputStream in, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(in, dataFormat, contexts);
        }

        public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(in, baseURI, dataFormat, contexts);
        }

        public void add(Reader reader, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(reader, dataFormat, contexts);
        }

        public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(reader, baseURI, dataFormat, contexts);
        }

        public void add(URL url, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(url, contexts);
        }

        public void add(URL url, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(url, dataFormat, contexts);
        }

        public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(url, baseURI, dataFormat, contexts);
        }

        public void add(File file, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(file, contexts);
        }

        public void add(File file, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(file, dataFormat, contexts);
        }

        public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
            this.delegate.add(file, baseURI, dataFormat, contexts);
        }

        public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
            this.delegate.add(subject, predicate, object, contexts);
        }

        public void add(Statement st, Resource ... contexts) throws RepositoryException {
            this.delegate.add(st, contexts);
        }

        public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.add(statements, contexts);
        }

        public void add(CloseableIteration<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.add(statements, contexts);
        }

        public void add(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.add(statements, contexts);
        }

        public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
            this.delegate.remove(subject, predicate, object, contexts);
        }

        public void remove(Statement st, Resource ... contexts) throws RepositoryException {
            this.delegate.remove(st, contexts);
        }

        public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.remove(statements, contexts);
        }

        public void remove(CloseableIteration<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.remove(statements, contexts);
        }

        public void remove(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
            this.delegate.remove(statements, contexts);
        }

        public void clear(Resource ... contexts) throws RepositoryException {
            this.delegate.clear(contexts);
        }

        public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
            return this.delegate.getNamespaces();
        }

        public String getNamespace(String prefix) throws RepositoryException {
            return this.delegate.getNamespace(prefix);
        }

        public void setNamespace(String prefix, String name) throws RepositoryException {
            this.delegate.setNamespace(prefix, name);
        }

        public void removeNamespace(String prefix) throws RepositoryException {
            this.delegate.removeNamespace(prefix);
        }

        public void clearNamespaces() throws RepositoryException {
            this.delegate.clearNamespaces();
        }
    }
}

