/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.eclipse.rdf4j.testsuite.sparql.vocabulary.EX;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class DefaultGraphTest
extends AbstractComplianceTest {
    public DefaultGraphTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testNullContext1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = " SELECT *  FROM DEFAULT  WHERE { ?s ?p ?o } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                org.junit.jupiter.api.Assertions.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)s);
                org.junit.jupiter.api.Assertions.assertNotEquals((Object)EX.BOB, (Object)s);
                org.junit.jupiter.api.Assertions.assertNotEquals((Object)EX.ALICE, (Object)s);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testNullContext2(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = " SELECT *  FROM rdf4j:nil  WHERE { ?s ?p ?o } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                org.junit.jupiter.api.Assertions.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)s);
                org.junit.jupiter.api.Assertions.assertNotEquals((Object)EX.BOB, (Object)s);
                org.junit.jupiter.api.Assertions.assertNotEquals((Object)EX.ALICE, (Object)s);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testSesameNilAsGraph(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = " SELECT *  WHERE { GRAPH rdf4j:nil { ?s ?p ?o } } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            List result = QueryResults.asList((QueryResult)tq.evaluate());
            Assertions.assertThat((int)result.size()).isGreaterThan(1);
            for (BindingSet bs : result) {
                Resource s = (Resource)bs.getValue("s");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)s);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{EX.BOB})).isNotEqualTo((Object)EX.BOB);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{EX.ALICE})).isNotEqualTo((Object)EX.ALICE);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("SesameNilAsGraph", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSesameNilAsGraph)), this.makeTest("NullContext2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testNullContext2)), this.makeTest("NullContext1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testNullContext1)));
    }
}

