/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class OrderByTest
extends AbstractComplianceTest {
    public OrderByTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testDistinctOptionalOrderBy(RepositoryConnection conn) throws Exception {
        conn.add((Reader)new StringReader("[] a <test:Class>.\n[] a <test:Class>; <test:nr> 123 ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "select distinct ?o ?nr { ?o a <test:Class> optional { ?o <test:nr> ?nr } } order by ?nr";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assertions.assertEquals((long)2L, (long)count);
        }
    }

    private void testOrderByVariableNotInUse(RepositoryConnection conn) throws Exception {
        conn.add((Reader)new StringReader("_:bob1 a <foaf:Person> ; rdfs:label \"Bob1\" .\n_:bob2 a <foaf:Person> ; rdfs:label \"Bob2\" ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "SELECT * WHERE { ?person a <foaf:Person> } ORDER BY ?score\n";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.distinct().count();
            Assertions.assertEquals((long)2L, (long)count);
        }
    }

    private void testDistinctOptionalOrderByMath(RepositoryConnection conn) throws Exception {
        conn.add((Reader)new StringReader("[] a <test:Class>.\n[] a <test:Class>; <test:nr> 123 ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "select distinct ?o ?nr { ?o a <test:Class> optional { ?o <test:nr> ?nr } } order by (?nr + STRLEN(?o))";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assertions.assertEquals((long)2L, (long)count);
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("DistinctOptionalOrderBy", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDistinctOptionalOrderBy)), this.makeTest("OrderByVariableNotInUse", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testOrderByVariableNotInUse)), this.makeTest("DistinctOptionalOrderByMath", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDistinctOptionalOrderByMath)));
    }
}

