/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.function.TransientFunction;

public class SpinxFunction
implements TransientFunction {
    private final String uri;
    private final List<Argument> arguments = new ArrayList<Argument>(4);
    private ScriptEngine scriptEngine;
    private CompiledScript compiledScript;
    private String script;
    private URI returnType;

    public SpinxFunction(String uri) {
        this.uri = uri;
    }

    public void setScriptEngine(ScriptEngine engine) {
        this.scriptEngine = engine;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setReturnType(URI datatype) {
        this.returnType = datatype;
    }

    public URI getReturnType() {
        return this.returnType;
    }

    public void addArgument(Argument arg) {
        this.arguments.add(arg);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.uri + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    public String getURI() {
        return this.uri;
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        Object result;
        Bindings bindings = this.scriptEngine.createBindings();
        for (int i = 0; i < args.length; ++i) {
            Literal argLiteral;
            Argument argument = this.arguments.get(i);
            Value arg = args[i];
            Object jsArg = arg instanceof Literal ? (XMLSchema.INTEGER.equals((Object)(argLiteral = (Literal)arg).getDatatype()) ? Integer.valueOf(argLiteral.intValue()) : (XMLSchema.DECIMAL.equals((Object)argLiteral.getDatatype()) ? Double.valueOf(argLiteral.doubleValue()) : argLiteral.getLabel())) : arg.stringValue();
            bindings.put(argument.getPredicate().getLocalName(), jsArg);
        }
        try {
            if (this.compiledScript == null && this.scriptEngine instanceof Compilable) {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.script);
            }
            result = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.script, bindings);
        }
        catch (ScriptException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        return this.returnType != null ? vf.createLiteral(result.toString(), this.returnType) : vf.createURI(result.toString());
    }
}

