/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.readonly;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.http.server.readonly.EvaluateResultHttpResponse;
import org.eclipse.rdf4j.http.server.readonly.sparql.SparqlQueryEvaluator;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.repository.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Experimental
@RestController
public class QueryResponder {
    private static final String[] ALL_GRAPHS = new String[0];
    @Autowired
    private final Repository repository;
    @Autowired
    private SparqlQueryEvaluator sparqlQueryEvaluator;

    @Autowired
    public QueryResponder(Repository repository) {
        this.repository = repository;
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public void sparqlPostURLencoded(@RequestParam(value="default-graph-uri", required=false) String defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String namedGraphUri, @RequestParam(value="query") String query, @RequestHeader(value="Accept") String acceptHeader, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            EvaluateResultHttpResponse result = new EvaluateResultHttpResponse(response);
            this.sparqlQueryEvaluator.evaluate(result, this.repository, query, acceptHeader, this.toArray(defaultGraphUri), this.toArray(namedGraphUri));
        }
        catch (IOException | IllegalStateException | MalformedQueryException e) {
            response.sendError(400);
        }
    }

    @RequestMapping(value={"/sparql"}, method={RequestMethod.GET})
    public void sparqlGet(@RequestParam(value="default-graph-uri", required=false) String defaultGraphUri, @RequestParam(value="named-graph-uri", required=false) String namedGraphUri, @RequestParam(value="query") String query, @RequestHeader(value="Accept") String acceptHeader, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            EvaluateResultHttpResponse result = new EvaluateResultHttpResponse(response);
            this.sparqlQueryEvaluator.evaluate(result, this.repository, query, acceptHeader, this.toArray(defaultGraphUri), this.toArray(namedGraphUri));
        }
        catch (IOException | IllegalStateException | MalformedQueryException e) {
            response.sendError(400, e.getMessage());
        }
    }

    private String[] toArray(String namedGraphUri) {
        if (namedGraphUri != null) {
            return new String[]{namedGraphUri};
        }
        return ALL_GRAPHS;
    }
}

