/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.demo.dao;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.spring.dao.RDF4JDao;
import org.eclipse.rdf4j.spring.dao.SimpleRDF4JCRUDDao;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.MutableBindings;
import org.eclipse.rdf4j.spring.dao.support.sparql.NamedSparqlSupplier;
import org.eclipse.rdf4j.spring.demo.model.EX;
import org.eclipse.rdf4j.spring.demo.model.Painting;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.eclipse.rdf4j.spring.util.QueryResultUtils;
import org.springframework.stereotype.Component;

@Component
public class PaintingDao
extends SimpleRDF4JCRUDDao<Painting, IRI> {
    public PaintingDao(RDF4JTemplate rdf4JTemplate) {
        super(rdf4JTemplate);
    }

    protected void populateIdBindings(MutableBindings bindingsBuilder, IRI iri) {
        bindingsBuilder.add(Painting.PAINTING_ID, iri);
    }

    protected RDF4JDao.NamedSparqlSupplierPreparer prepareNamedSparqlSuppliers(RDF4JDao.NamedSparqlSupplierPreparer preparer) {
        return null;
    }

    protected Painting mapSolution(BindingSet querySolution) {
        Painting painting = new Painting();
        painting.setId(QueryResultUtils.getIRI((BindingSet)querySolution, (Variable)Painting.PAINTING_ID));
        painting.setTechnique(QueryResultUtils.getString((BindingSet)querySolution, (Variable)Painting.PAINTING_TECHNIQUE));
        painting.setTitle(QueryResultUtils.getString((BindingSet)querySolution, (Variable)Painting.PAINTING_LABEL));
        painting.setArtistId(QueryResultUtils.getIRI((BindingSet)querySolution, (Variable)Painting.PAINTING_ARTIST_ID));
        return painting;
    }

    protected String getReadQuery() {
        return ((SelectQuery)Queries.SELECT((Projectable[])new Projectable[]{Painting.PAINTING_ID, Painting.PAINTING_LABEL, Painting.PAINTING_TECHNIQUE, Painting.PAINTING_ARTIST_ID}).where(new GraphPattern[]{Painting.PAINTING_ID.isA(new RdfObject[]{Rdf.iri((IRI)EX.Painting)}).andHas((RdfPredicate)Rdf.iri((IRI)EX.technique), new RdfObject[]{Painting.PAINTING_TECHNIQUE}).andHas((RdfPredicate)Rdf.iri((IRI)RDFS.LABEL), new RdfObject[]{Painting.PAINTING_LABEL}), Painting.PAINTING_ARTIST_ID.has((RdfPredicate)Rdf.iri((IRI)EX.creatorOf), new RdfObject[]{Painting.PAINTING_ID})})).getQueryString();
    }

    protected NamedSparqlSupplier getInsertSparql(Painting painting) {
        return NamedSparqlSupplier.of((String)"insert", () -> Queries.INSERT((TriplePattern[])new TriplePattern[]{Painting.PAINTING_ID.isA(new RdfObject[]{Rdf.iri((IRI)EX.Painting)}).andHas((RdfPredicate)Rdf.iri((IRI)EX.technique), new RdfObject[]{Painting.PAINTING_TECHNIQUE}).andHas((RdfPredicate)Rdf.iri((IRI)RDFS.LABEL), new RdfObject[]{Painting.PAINTING_LABEL}), Painting.PAINTING_ARTIST_ID.has((RdfPredicate)Rdf.iri((IRI)EX.creatorOf), new RdfObject[]{Painting.PAINTING_ID})}).getQueryString());
    }

    protected void populateBindingsForUpdate(MutableBindings bindingsBuilder, Painting painting) {
        bindingsBuilder.add(Painting.PAINTING_LABEL, painting.getTitle()).add(Painting.PAINTING_TECHNIQUE, painting.getTechnique()).add(Painting.PAINTING_ARTIST_ID, painting.getArtistId());
    }

    protected IRI getInputId(Painting painting) {
        if (painting.getId() == null) {
            return this.getRdf4JTemplate().getNewUUID();
        }
        return painting.getId();
    }
}

