/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateWithModelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RepositoryConnection con;
    private final ModelBuilder modelBuilder;

    public UpdateWithModelBuilder(RepositoryConnection con) {
        this.con = con;
        this.modelBuilder = new ModelBuilder();
    }

    public UpdateWithModelBuilder setNamespace(Namespace ns) {
        this.modelBuilder.setNamespace(ns);
        return this;
    }

    public UpdateWithModelBuilder setNamespace(String prefix, String namespace) {
        this.modelBuilder.setNamespace(prefix, namespace);
        return this;
    }

    public UpdateWithModelBuilder subject(Resource subject) {
        this.modelBuilder.subject(subject);
        return this;
    }

    public UpdateWithModelBuilder subject(String prefixedNameOrIri) {
        this.modelBuilder.subject(prefixedNameOrIri);
        return this;
    }

    public UpdateWithModelBuilder namedGraph(Resource namedGraph) {
        this.modelBuilder.namedGraph(namedGraph);
        return this;
    }

    public UpdateWithModelBuilder namedGraph(String prefixedNameOrIRI) {
        this.modelBuilder.namedGraph(prefixedNameOrIRI);
        return this;
    }

    public UpdateWithModelBuilder defaultGraph() {
        this.modelBuilder.defaultGraph();
        return this;
    }

    public UpdateWithModelBuilder addMaybe(Resource subject, IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(Resource subject, IRI predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String subject, IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String subject, IRI predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String subject, String predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String subject, String predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{predicate, object})) {
            return this.add(predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(IRI predicate, Object object) {
        this.modelBuilder.add(predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{predicate, object})) {
            return this.add(predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String predicate, Object object) {
        this.modelBuilder.add(predicate, object);
        return this;
    }

    public void acceptConnection(Consumer<RepositoryConnection> connectionConsumer) {
        connectionConsumer.accept(this.con);
    }

    public <T> T applyToConnection(Function<RepositoryConnection, T> function) {
        return function.apply(this.con);
    }

    public BNode createBNode() {
        return this.con.getValueFactory().createBNode();
    }

    public UpdateWithModelBuilder withSink(Consumer<Collection<Statement>> consumer) {
        ArrayList sink = new ArrayList();
        consumer.accept(sink);
        if (sink.size() > 0) {
            sink.stream().forEach(s -> this.modelBuilder.add(s.getSubject(), s.getPredicate(), (Object)s.getObject()));
        }
        return this;
    }

    public void execute() {
        Model model = this.modelBuilder.build();
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            Rio.write((Iterable)model, (Writer)sw, (RDFFormat)RDFFormat.TURTLE);
            logger.debug("adding the following triples:\n{}", (Object)sw.toString());
        }
        this.con.add((Iterable)model, new Resource[0]);
    }
}

