/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationlog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.spring.dao.exception.RDF4JSpringException;
import org.eclipse.rdf4j.spring.operationlog.LoggingGraphQuery;
import org.eclipse.rdf4j.spring.operationlog.LoggingTupleQuery;
import org.eclipse.rdf4j.spring.operationlog.LoggingUpdate;
import org.eclipse.rdf4j.spring.operationlog.log.OperationLog;
import org.eclipse.rdf4j.spring.operationlog.log.PseudoOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRepositoryConnection
extends RepositoryConnectionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    OperationLog operationLog;

    public LoggingRepositoryConnection(RepositoryConnection delegate, OperationLog operationLog) {
        super(delegate.getRepository(), delegate);
        this.operationLog = operationLog;
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException, RepositoryException {
        this.logWarning();
        return new LoggingTupleQuery(this.getDelegate().prepareTupleQuery(ql, queryString, baseURI), this.operationLog);
    }

    public TupleQuery prepareTupleQuery(String query) throws RepositoryException, MalformedQueryException {
        this.logWarning();
        return new LoggingTupleQuery(this.getDelegate().prepareTupleQuery(query), this.operationLog);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        this.logWarning();
        return new LoggingTupleQuery(this.getDelegate().prepareTupleQuery(ql, query), this.operationLog);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException, RepositoryException {
        this.logWarning();
        return new LoggingGraphQuery(this.getDelegate().prepareGraphQuery(ql, queryString, baseURI), this.operationLog);
    }

    public GraphQuery prepareGraphQuery(String query) throws RepositoryException, MalformedQueryException {
        this.logWarning();
        return new LoggingGraphQuery(this.getDelegate().prepareGraphQuery(query), this.operationLog);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        this.logWarning();
        return new LoggingGraphQuery(this.getDelegate().prepareGraphQuery(ql, query), this.operationLog);
    }

    public Update prepareUpdate(QueryLanguage ql, String updateString, String baseURI) throws MalformedQueryException, RepositoryException {
        this.logWarning();
        return new LoggingUpdate(this.getDelegate().prepareUpdate(ql, updateString, baseURI), this.operationLog);
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        this.logWarning();
        return this.operationLog.runWithLog(PseudoOperation.forGetSatements(subj, pred, obj, contexts), () -> this.getDelegate().getStatements(subj, pred, obj, contexts));
    }

    public void add(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(statements, contexts), () -> this.getDelegate().add(statements, contexts));
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(file, baseURI, dataFormat, contexts), this.wrapInRuntimeException(() -> this.getDelegate().add(file, baseURI, dataFormat, contexts)));
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(in, baseURI, dataFormat, contexts), this.wrapInRuntimeException(() -> this.getDelegate().add(in, baseURI, dataFormat, contexts)));
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(statements, contexts), () -> this.getDelegate().add(statements, contexts));
    }

    public void add(CloseableIteration<? extends Statement> statementIter, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(statementIter, contexts), this.wrapInRuntimeException(() -> this.getDelegate().add(statementIter, contexts)));
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(reader, baseURI, dataFormat, contexts), this.wrapInRuntimeException(() -> this.getDelegate().add(reader, baseURI, dataFormat, contexts)));
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(subject, predicate, object, contexts), () -> this.getDelegate().add(subject, predicate, object, contexts));
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(st, contexts), () -> this.getDelegate().add(st, contexts));
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forAdd(url, baseURI, dataFormat, contexts), this.wrapInRuntimeException(() -> this.getDelegate().add(url, baseURI, dataFormat, contexts)));
    }

    public void remove(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forRemove(statements, contexts), this.wrapInRuntimeException(() -> this.getDelegate().remove(statements, contexts)));
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forRemove(statements, contexts), () -> this.getDelegate().remove(statements, contexts));
    }

    public void remove(CloseableIteration<? extends Statement> statementIter, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forRemove(statementIter, contexts), this.wrapInRuntimeException(() -> this.getDelegate().remove(statementIter, contexts)));
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forRemove(subject, predicate, object, contexts), () -> this.getDelegate().remove(subject, predicate, object, contexts));
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forRemove(st, contexts), () -> this.getDelegate().remove(st, contexts));
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        this.operationLog.runWithLog(PseudoOperation.forClear(contexts), () -> this.getDelegate().clear(contexts));
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.operationLog.runWithLog(PseudoOperation.forGetSatements(subj, pred, obj, includeInferred, contexts), () -> this.getDelegate().getStatements(subj, pred, obj, includeInferred, contexts));
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.operationLog.runWithLog(PseudoOperation.forHasStatement(subj, pred, obj, includeInferred, contexts), () -> this.getDelegate().hasStatement(subj, pred, obj, includeInferred, contexts));
    }

    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.operationLog.runWithLog(PseudoOperation.forHasStatement(st, includeInferred, contexts), () -> this.getDelegate().hasStatement(st, includeInferred, contexts));
    }

    public long size(Resource ... contexts) throws RepositoryException {
        return this.operationLog.runWithLog(PseudoOperation.forSize(contexts), () -> this.getDelegate().size(contexts));
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        super.removeNamespace(prefix);
    }

    private Runnable wrapInRuntimeException(ExceptionThrowingRunnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Exception e) {
                throw new RDF4JSpringException(e);
            }
        };
    }

    private void logWarning() {
        logger.warn("rdf4j operations (queries and updates) are being timed and logged. Don't do this in production as the log is not limited in size! You can disable this feature by setting the configuration property 'org.eclipse.rdf4j.spring.operationlog.enabled' to 'false'");
    }

    private static interface ExceptionThrowingRunnable {
        public void run() throws Exception;
    }
}

