/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.opbuilder;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.spring.dao.exception.mapper.ExceptionMapper;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.OperationBuilder;
import org.eclipse.rdf4j.spring.dao.support.operation.GraphQueryResultConverter;
import org.eclipse.rdf4j.spring.dao.support.operation.OperationUtils;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQueryEvaluationBuilder
extends OperationBuilder<GraphQuery, GraphQueryEvaluationBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public GraphQueryEvaluationBuilder(GraphQuery operation, RDF4JTemplate template) {
        super(operation, template);
    }

    public GraphQueryResultConverter evaluateAndConvert() {
        return this.withTryCatchAndLog(() -> {
            GraphQuery graphQuery = (GraphQuery)this.getOperation();
            OperationUtils.setBindings((Operation)graphQuery, this.getBindings());
            return new GraphQueryResultConverter(graphQuery.evaluate());
        }, "Error evaluating GraphQuery:\n" + ((GraphQuery)this.getOperation()).toString());
    }

    private <T> T withTryCatchAndLog(Supplier<T> supplier, String errorString) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            logger.debug(errorString, (Throwable)e);
            throw ExceptionMapper.mapException(errorString, e);
        }
    }
}

