/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationlog.log.jmx;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.spring.dao.exception.RDF4JSpringException;
import org.eclipse.rdf4j.spring.operationlog.log.OperationExecutionStats;

public class AggregatedOperationStats
implements Cloneable {
    private String operation = null;
    private int count = 0;
    private int failed = 0;
    private long cumulativeTime = 0L;
    private Integer uniqueBindingsCount = null;
    private Set<Integer> bindingsHashcodes = new HashSet<Integer>();

    public static AggregatedOperationStats build(OperationExecutionStats stats) {
        return new AggregatedOperationStats().buildNext(stats);
    }

    protected Object clone() {
        AggregatedOperationStats theClone;
        try {
            theClone = (AggregatedOperationStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RDF4JSpringException("could not clone", e);
        }
        theClone.operation = this.operation;
        theClone.count = this.count;
        theClone.failed = this.failed;
        theClone.cumulativeTime = this.cumulativeTime;
        theClone.uniqueBindingsCount = this.uniqueBindingsCount;
        theClone.bindingsHashcodes = new HashSet<Integer>();
        theClone.bindingsHashcodes.addAll(this.bindingsHashcodes);
        return theClone;
    }

    public void setUniqueBindingsCount(int uniqueBindingsCount) {
        this.uniqueBindingsCount = uniqueBindingsCount;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCumulativeTime(long cumulativeTime) {
        this.cumulativeTime = cumulativeTime;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public long getAverageTime() {
        return this.cumulativeTime / (long)this.count;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getCount() {
        return this.count;
    }

    public int getFailed() {
        return this.failed;
    }

    public long getCumulativeTime() {
        return this.cumulativeTime;
    }

    public int getUniqueBindingsCount() {
        return this.uniqueBindingsCount != null ? this.uniqueBindingsCount.intValue() : this.bindingsHashcodes.size();
    }

    public AggregatedOperationStats buildNext(OperationExecutionStats stats) {
        String newOperation = stats.getOperation();
        AggregatedOperationStats newStats = (AggregatedOperationStats)this.clone();
        if (newStats.operation != null) {
            if (!newStats.operation.equals(newOperation)) {
                throw new IllegalArgumentException("Cannot add to aggregated stats: operations differ. Existing operation:\n" + newStats.operation + "\n, new operation:\n" + newOperation);
            }
        } else {
            newStats.operation = newOperation;
        }
        newStats.bindingsHashcodes.add(stats.getBindingsHashCode());
        ++newStats.count;
        if (stats.isFailed()) {
            ++newStats.failed;
        }
        newStats.cumulativeTime += stats.getQueryDuration();
        return newStats;
    }
}

