/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.repository.remote;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="rdf4j.spring.repository.remote")
public class RemoteRepositoryProperties {
    @NotBlank
    @Pattern(regexp="^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]")
    private @NotBlank @Pattern(regexp="^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") String managerUrl = null;
    private String username = null;
    private String password = null;
    @NotBlank
    @Length(min=1)
    private @NotBlank @Length(min=1) String name = null;

    public String getManagerUrl() {
        return this.managerUrl;
    }

    public void setManagerUrl(String managerUrl) {
        this.managerUrl = managerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUsernamePasswordConfigured() {
        return this.username != null && this.password != null;
    }

    public String toString() {
        return "RemoteRepositoryConfig{managerUrl='" + this.managerUrl + "'" + (String)(this.username != null ? ", username='" + this.username + "'" : "") + (this.password != null ? ", password='****'" : "") + ", name='" + this.name + "' }";
    }
}

