/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.spring.resultcache.CachingRepositoryConnection;
import org.eclipse.rdf4j.spring.resultcache.LRUResultCache;
import org.eclipse.rdf4j.spring.resultcache.ResultCacheProperties;
import org.eclipse.rdf4j.spring.resultcache.ReusableGraphQueryResult;
import org.eclipse.rdf4j.spring.resultcache.ReusableTupleQueryResult;
import org.eclipse.rdf4j.spring.support.connectionfactory.DelegatingRepositoryConnectionFactory;
import org.eclipse.rdf4j.spring.support.connectionfactory.RepositoryConnectionFactory;
import org.eclipse.rdf4j.spring.util.RepositoryConnectionWrappingUtils;

public class CachingRepositoryConnectionFactory
extends DelegatingRepositoryConnectionFactory {
    private final LRUResultCache<ReusableTupleQueryResult> globalTupleQueryResultCache;
    private final LRUResultCache<ReusableGraphQueryResult> globalGraphQueryResultCache;
    private final ResultCacheProperties properties;

    public CachingRepositoryConnectionFactory(RepositoryConnectionFactory delegate, ResultCacheProperties properties) {
        super(delegate);
        this.properties = properties;
        this.globalGraphQueryResultCache = new LRUResultCache(properties);
        this.globalTupleQueryResultCache = new LRUResultCache(properties);
    }

    @Override
    public RepositoryConnection getConnection() {
        return RepositoryConnectionWrappingUtils.wrapOnce(this.getDelegate().getConnection(), con -> new CachingRepositoryConnection((RepositoryConnection)con, this.globalTupleQueryResultCache, this.globalGraphQueryResultCache, this.properties), CachingRepositoryConnection.class);
    }
}

