/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import com.google.common.base.MoreObjects;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.filters.AccurateRepositoryBloomFilter;
import org.eclipse.rdf4j.repository.filters.RepositoryBloomFilter;
import org.eclipse.rdf4j.sail.federation.PrefixHashSet;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.algebra.OwnedTupleExpr;

public class FederationJoinOptimizer
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private final Collection<? extends RepositoryConnection> members;
    private final Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters;
    private Map<Resource, List<RepositoryConnection>> contextToMemberMap;
    private final PrefixHashSet localSpace;
    private final boolean distinct;
    private Dataset dataset;

    public FederationJoinOptimizer(Collection<? extends RepositoryConnection> members, boolean distinct, PrefixHashSet localSpace) {
        this(members, distinct, localSpace, c -> AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
    }

    public FederationJoinOptimizer(Collection<? extends RepositoryConnection> members, boolean distinct, PrefixHashSet localSpace, Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters) {
        this.members = members;
        this.localSpace = localSpace;
        this.bloomFilters = bloomFilters;
        this.distinct = distinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Resource, List<RepositoryConnection>> createContextToMemberMap(Collection<? extends RepositoryConnection> members) throws RepositoryException {
        HashMap<Resource, List<RepositoryConnection>> contextToMemberMap = new HashMap<Resource, List<RepositoryConnection>>(members.size() + 1);
        for (RepositoryConnection repositoryConnection : members) {
            try (RepositoryResult res = repositoryConnection.getContextIDs();){
                while (res.hasNext()) {
                    Resource ctx = (Resource)res.next();
                    ArrayList<RepositoryConnection> contextMembers = (ArrayList<RepositoryConnection>)contextToMemberMap.get(ctx);
                    if (contextMembers == null) {
                        contextMembers = new ArrayList<RepositoryConnection>();
                        contextToMemberMap.put(ctx, contextMembers);
                    }
                    contextMembers.add(repositoryConnection);
                }
            }
        }
        return contextToMemberMap;
    }

    @Override
    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        this.dataset = dataset;
        try {
            query.visit((QueryModelVisitor)this);
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
        finally {
            this.dataset = null;
        }
    }

    public void meetOther(QueryModelNode node) throws RepositoryException {
        if (node instanceof NaryJoin) {
            this.meetMultiJoin((NaryJoin)node);
        } else {
            super.meetOther(node);
        }
    }

    public void meetMultiJoin(NaryJoin node) throws RepositoryException {
        super.meetOther((QueryModelNode)node);
        ArrayList<Owned<NaryJoin>> ows = new ArrayList<Owned<NaryJoin>>();
        ArrayList<LocalJoin> vars = new ArrayList<LocalJoin>();
        for (TupleExpr arg : node.getArgs()) {
            RepositoryConnection member = this.getSingleOwner(arg);
            if (!ows.isEmpty() && ((Owned)ows.get(ows.size() - 1)).getOwner() == member) {
                ((NaryJoin)((Object)((Owned)ows.get(ows.size() - 1)).getOperation())).addArg(arg.clone());
                continue;
            }
            ows.add(new Owned<NaryJoin>(member, new NaryJoin(arg.clone())));
        }
        for (TupleExpr arg : node.getArgs()) {
            Var subj = this.getLocalSubject(arg);
            LocalJoin local = this.findLocalJoin(subj, vars);
            if (local == null) {
                vars.add(new LocalJoin(subj, new NaryJoin(arg.clone())));
                continue;
            }
            local.getJoin().addArg(arg.clone());
        }
        this.addOwners(node, ows, vars);
    }

    public void meet(LeftJoin node) throws RepositoryException {
        super.meet(node);
        Var leftSubject = this.getLocalSubject(node.getLeftArg());
        Var rightSubject = this.getLocalSubject(node.getRightArg());
        boolean local = leftSubject != null && leftSubject.equals((Object)rightSubject);
        RepositoryConnection leftOwner = this.getSingleOwner(node.getLeftArg());
        RepositoryConnection rightOwner = this.getSingleOwner(node.getRightArg());
        this.addOwners(node, leftOwner, rightOwner, local);
    }

    public void meet(Union node) throws RepositoryException {
        super.meet(node);
        ArrayList<Owned<TupleExpr>> ows = new ArrayList<Owned<TupleExpr>>();
        for (TupleExpr arg : new TupleExpr[]{node.getLeftArg(), node.getRightArg()}) {
            RepositoryConnection member = this.getSingleOwner(arg);
            int idx = ows.size() - 1;
            if (!ows.isEmpty() && ((Owned)ows.get(idx)).getOwner() == member) {
                TupleExpr union = (TupleExpr)((Owned)ows.get(idx)).getOperation();
                union = new Union(union, arg.clone());
                ((Owned)ows.get(idx)).setOperation(union);
                continue;
            }
            ows.add(new Owned<TupleExpr>(member, arg.clone()));
        }
        this.addOwners(node, ows);
    }

    protected void meetUnaryTupleOperator(UnaryTupleOperator node) throws RepositoryException {
        super.meetUnaryTupleOperator(node);
        RepositoryConnection owner = this.getSingleOwner(node.getArg());
        if (owner != null) {
            node.replaceWith((QueryModelNode)new OwnedTupleExpr(owner, (TupleExpr)node.clone()));
        }
    }

    private LocalJoin findLocalJoin(Var subj, List<LocalJoin> vars) {
        LocalJoin result = null;
        if (!vars.isEmpty() && vars.get(vars.size() - 1).getVar() == subj) {
            result = vars.get(vars.size() - 1);
        } else {
            for (LocalJoin local : vars) {
                if (subj == null || !subj.equals((Object)local.getVar())) continue;
                result = local;
                break;
            }
        }
        return result;
    }

    private RepositoryConnection getSingleOwner(TupleExpr arg) throws RepositoryException {
        return new OwnerScanner().getSingleOwner(arg);
    }

    private Var getLocalSubject(TupleExpr arg) throws RepositoryException {
        return new LocalScanner().getLocalSubject(arg);
    }

    private void addOwners(NaryJoin node, List<Owned<NaryJoin>> ows, List<LocalJoin> vars) throws RepositoryException {
        boolean local = this.isLocal(vars);
        if (ows.size() == 1) {
            RepositoryConnection owner = ows.get(0).getOwner();
            if (owner == null) {
                if (local) {
                    this.performReplacementsInNode(node, vars);
                }
            } else {
                node.replaceWith((QueryModelNode)new OwnedTupleExpr(owner, node.clone()));
            }
        } else if (local) {
            NaryJoin replacement = new NaryJoin();
            for (LocalJoin v : vars) {
                Var var = v.getVar();
                NaryJoin join = v.getJoin();
                if (var == null) {
                    for (TupleExpr expr : join.getArgs()) {
                        replacement.addArg(expr);
                    }
                    continue;
                }
                replacement = this.optimizeReplacementJoin(replacement, join);
            }
            node.replaceWith((QueryModelNode)replacement);
        } else {
            NaryJoin replacement = this.generateReplacementFromOwnedJoins(ows);
            node.replaceWith((QueryModelNode)replacement);
        }
    }

    private NaryJoin generateReplacementFromOwnedJoins(List<Owned<NaryJoin>> ows) {
        NaryJoin replacement = new NaryJoin();
        for (Owned<NaryJoin> e : ows) {
            RepositoryConnection owner = e.getOwner();
            NaryJoin join = e.getOperation();
            if (owner == null) {
                for (TupleExpr arg : join.getArgs()) {
                    replacement.addArg(arg);
                }
                continue;
            }
            replacement.addArg(new OwnedTupleExpr(owner, join));
        }
        return replacement;
    }

    private AbstractQueryModelNode optimizeReplacementJoin(AbstractQueryModelNode candidate, NaryJoin join) throws RepositoryException {
        boolean multipleOwners = false;
        RepositoryConnection owner = null;
        for (TupleExpr expr : join.getArgs()) {
            RepositoryConnection connection = this.getSingleOwner(expr);
            if (owner == null) {
                owner = connection;
                continue;
            }
            if (connection == null || owner == connection) continue;
            multipleOwners = true;
            owner = null;
            break;
        }
        AbstractQueryModelNode replacement = candidate;
        if (multipleOwners) {
            replacement = new EmptySet();
        } else if (owner == null) {
            this.addUnionOfMembers((NaryJoin)replacement, join);
        } else {
            this.addArg((NaryJoin)replacement, new OwnedTupleExpr(owner, join));
        }
        return replacement;
    }

    private void addUnionOfMembers(NaryJoin replacement, NaryJoin join) {
        OwnedTupleExpr union = null;
        for (RepositoryConnection repositoryConnection : this.members) {
            OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, join.clone());
            union = union == null ? arg : new Union((TupleExpr)union, (TupleExpr)arg);
        }
        if (union != null) {
            replacement.addArg(union);
        }
    }

    private void performReplacementsInNode(NaryJoin node, List<LocalJoin> vars) {
        NaryJoin replacement = new NaryJoin();
        for (LocalJoin e : vars) {
            if (this.distinct || e.getVar() != null) {
                OwnedTupleExpr union = null;
                for (RepositoryConnection repositoryConnection : this.members) {
                    OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, e.getJoin().clone());
                    union = union == null ? arg : new Union((TupleExpr)union, (TupleExpr)arg);
                }
                if (union == null) continue;
                replacement.addArg(union);
                continue;
            }
            for (TupleExpr expr : e.getJoin().getArgs()) {
                replacement.addArg(expr);
            }
        }
        node.replaceWith((QueryModelNode)replacement);
    }

    private boolean isLocal(List<LocalJoin> vars) {
        boolean local = false;
        if (vars.size() > 1 || vars.size() == 1 && vars.get(0).getVar() != null) {
            for (LocalJoin e : vars) {
                if (e.getVar() == null || e.getJoin().getNumberOfArguments() <= 1) continue;
                local = true;
                break;
            }
        }
        return local;
    }

    private void addArg(NaryJoin destination, OwnedTupleExpr newArg) {
        TupleExpr expr;
        boolean found = false;
        int size = destination.getNumberOfArguments();
        if (size > 0 && (expr = (TupleExpr)destination.getArg(size - 1)) instanceof OwnedTupleExpr) {
            boolean sameOwner;
            OwnedTupleExpr existing = (OwnedTupleExpr)expr;
            boolean bl = sameOwner = newArg.getOwner() == existing.getOwner();
            if (sameOwner && existing.getArg() instanceof NaryJoin) {
                NaryJoin existingJoin = (NaryJoin)existing.getArg();
                NaryJoin newJoin = (NaryJoin)newArg.getArg();
                for (TupleExpr t : newJoin.getArgs()) {
                    existingJoin.addArg(t);
                }
                found = true;
            }
        }
        if (!found) {
            destination.addArg(newArg);
        }
    }

    private void addOwners(LeftJoin node, RepositoryConnection leftOwner, RepositoryConnection rightOwner, boolean local) {
        if (leftOwner == null && rightOwner == null) {
            if (local) {
                OwnedTupleExpr union = null;
                for (RepositoryConnection repositoryConnection : this.members) {
                    OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, (TupleExpr)node.clone());
                    union = union == null ? arg : new Union((TupleExpr)union, (TupleExpr)arg);
                }
                node.replaceWith(union);
            }
        } else if (leftOwner == rightOwner) {
            node.replaceWith((QueryModelNode)new OwnedTupleExpr(leftOwner, (TupleExpr)node.clone()));
        } else if (local) {
            this.addDistinctOwnersLocal(node, leftOwner, rightOwner);
        } else {
            this.addDistinctOwnersNonLocal(node, leftOwner, rightOwner);
        }
    }

    private void addDistinctOwnersNonLocal(LeftJoin node, RepositoryConnection leftOwner, RepositoryConnection rightOwner) {
        if (leftOwner != null) {
            node.getLeftArg().replaceWith((QueryModelNode)new OwnedTupleExpr(leftOwner, node.getLeftArg().clone()));
        }
        if (rightOwner != null) {
            node.getRightArg().replaceWith((QueryModelNode)new OwnedTupleExpr(rightOwner, node.getRightArg().clone()));
        }
    }

    private void addDistinctOwnersLocal(LeftJoin node, RepositoryConnection leftOwner, RepositoryConnection rightOwner) {
        if (rightOwner == null) {
            node.replaceWith((QueryModelNode)new OwnedTupleExpr(leftOwner, (TupleExpr)node.clone()));
        } else if (leftOwner == null) {
            OwnedTupleExpr union = null;
            for (RepositoryConnection repositoryConnection : this.members) {
                OwnedTupleExpr arg;
                if (rightOwner == repositoryConnection) {
                    arg = new OwnedTupleExpr(repositoryConnection, (TupleExpr)node.clone());
                    union = union == null ? arg : new Union((TupleExpr)union, (TupleExpr)arg);
                    continue;
                }
                arg = new OwnedTupleExpr(repositoryConnection, node.getLeftArg().clone());
                union = union == null ? arg : new Union((TupleExpr)union, (TupleExpr)arg);
            }
            node.replaceWith(union);
        } else {
            node.replaceWith((QueryModelNode)new OwnedTupleExpr(leftOwner, node.getLeftArg().clone()));
        }
    }

    private void addOwners(Union node, List<Owned<TupleExpr>> ows) {
        if (ows.size() == 1) {
            RepositoryConnection owner = ows.get(0).getOwner();
            if (owner != null) {
                node.replaceWith((QueryModelNode)new OwnedTupleExpr(owner, (TupleExpr)node.clone()));
            }
        } else {
            OwnedTupleExpr replacement = null;
            for (Owned<TupleExpr> e : ows) {
                RepositoryConnection owner = e.getOwner();
                TupleExpr union = e.getOperation();
                if (owner == null) {
                    for (TupleExpr arg : this.getUnionArgs(union)) {
                        replacement = replacement == null ? arg.clone() : new Union((TupleExpr)replacement, arg.clone());
                    }
                    continue;
                }
                OwnedTupleExpr arg = new OwnedTupleExpr(owner, union);
                replacement = replacement == null ? arg : new Union((TupleExpr)replacement, (TupleExpr)arg);
            }
            node.replaceWith(replacement);
        }
    }

    private List<TupleExpr> getUnionArgs(TupleExpr union) {
        return this.getUnionArgs(union, new ArrayList<TupleExpr>());
    }

    private List<TupleExpr> getUnionArgs(TupleExpr union, List<TupleExpr> list) {
        if (union instanceof Union) {
            this.getUnionArgs(((Union)union).getLeftArg(), list);
            this.getUnionArgs(((Union)union).getRightArg(), list);
        } else {
            list.add(union);
        }
        return list;
    }

    private class LocalScanner
    extends AbstractQueryModelVisitor<RepositoryException> {
        private boolean isLocal;
        private Var relative;

        private LocalScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Var getLocalSubject(TupleExpr arg) throws RepositoryException {
            boolean local_stack = this.isLocal;
            Var relative_stack = this.relative;
            try {
                this.isLocal = true;
                this.relative = null;
                arg.visit((QueryModelVisitor)this);
                Var var = this.relative;
                return var;
            }
            finally {
                this.isLocal = local_stack;
                this.relative = relative_stack;
            }
        }

        public void meet(StatementPattern node) throws RepositoryException {
            super.meet(node);
            IRI pred = (IRI)node.getPredicateVar().getValue();
            if (pred != null && FederationJoinOptimizer.this.localSpace != null && FederationJoinOptimizer.this.localSpace.match(pred.stringValue())) {
                this.local(node.getSubjectVar());
            } else {
                this.notLocal();
            }
        }

        private void local(Var subj) {
            if (this.isLocal && this.relative == null) {
                this.relative = subj;
            } else if (!subj.equals((Object)this.relative)) {
                this.notLocal();
            }
        }

        private void notLocal() {
            this.isLocal = false;
            this.relative = null;
        }
    }

    private class OwnerScanner
    extends AbstractQueryModelVisitor<RepositoryException> {
        private boolean shared;
        private RepositoryConnection owner;

        private OwnerScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RepositoryConnection getSingleOwner(TupleExpr arg) throws RepositoryException {
            boolean pre_shared = this.shared;
            RepositoryConnection pre_owner = this.owner;
            try {
                this.shared = false;
                this.owner = null;
                arg.visit((QueryModelVisitor)this);
                RepositoryConnection repositoryConnection = this.owner;
                return repositoryConnection;
            }
            finally {
                this.shared = pre_shared;
                this.owner = pre_owner;
            }
        }

        public void meet(StatementPattern node) throws RepositoryException {
            super.meet(node);
            Resource subj = (Resource)node.getSubjectVar().getValue();
            IRI pred = (IRI)node.getPredicateVar().getValue();
            Value obj = node.getObjectVar().getValue();
            Resource[] ctx = this.getContexts(node.getContextVar());
            RepositoryConnection member = this.getSingleOwner(subj, pred, obj, ctx);
            if (member == null) {
                this.multipleOwners();
            } else {
                this.usedBy(member);
            }
        }

        public void meetOther(QueryModelNode node) throws RepositoryException {
            if (node instanceof OwnedTupleExpr) {
                this.meetOwnedTupleExpr((OwnedTupleExpr)node);
            } else {
                super.meetOther(node);
            }
        }

        private void meetOwnedTupleExpr(OwnedTupleExpr node) throws RepositoryException {
            this.usedBy(node.getOwner());
        }

        private Resource[] getContexts(Var var) {
            Resource[] resourceArray;
            if (var == null || !var.hasValue()) {
                resourceArray = new Resource[]{};
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = (Resource)var.getValue();
            }
            return resourceArray;
        }

        private RepositoryConnection getSingleOwner(Resource subj, IRI pred, Value obj, Resource[] ctx) throws RepositoryException {
            List<Object> explicitContexts;
            RepositoryConnection result = null;
            if (FederationJoinOptimizer.this.contextToMemberMap == null) {
                FederationJoinOptimizer.this.contextToMemberMap = FederationJoinOptimizer.createContextToMemberMap(FederationJoinOptimizer.this.members);
            }
            HashSet results = new HashSet();
            if (ctx.length > 0) {
                explicitContexts = Arrays.asList(ctx);
            } else if (FederationJoinOptimizer.this.dataset != null) {
                explicitContexts = new ArrayList<Resource>();
                explicitContexts.addAll(FederationJoinOptimizer.this.dataset.getDefaultGraphs());
                explicitContexts.addAll(FederationJoinOptimizer.this.dataset.getNamedGraphs());
            } else {
                explicitContexts = Collections.emptyList();
            }
            for (Resource resource : explicitContexts) {
                List contextRepos = (List)FederationJoinOptimizer.this.contextToMemberMap.get(resource);
                if (contextRepos == null) continue;
                results.addAll(contextRepos);
            }
            if (results.size() == 1) {
                result = (RepositoryConnection)results.iterator().next();
            } else {
                for (RepositoryConnection repositoryConnection : results) {
                    RepositoryBloomFilter bloomFilter = (RepositoryBloomFilter)MoreObjects.firstNonNull(FederationJoinOptimizer.this.bloomFilters.apply(repositoryConnection.getRepository()), (Object)AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
                    if (!bloomFilter.mayHaveStatement(repositoryConnection, subj, pred, obj, ctx)) continue;
                    if (result == null) {
                        result = repositoryConnection;
                        continue;
                    }
                    if (result == repositoryConnection) continue;
                    result = null;
                    break;
                }
            }
            return result;
        }

        private void usedBy(RepositoryConnection member) {
            if (!this.shared && this.owner == null) {
                this.owner = member;
            } else if (this.owner != member) {
                this.multipleOwners();
            }
        }

        private void multipleOwners() {
            this.owner = null;
            this.shared = true;
        }
    }

    private static class LocalJoin {
        private final Var var;
        private final NaryJoin join;

        public LocalJoin(Var key, NaryJoin value) {
            this.var = key;
            this.join = value;
        }

        public Var getVar() {
            return this.var;
        }

        public NaryJoin getJoin() {
            return this.join;
        }

        public String toString() {
            return this.var + "=" + (Object)((Object)this.join);
        }
    }

    private static class Owned<O> {
        private final RepositoryConnection owner;
        private O operation;

        public Owned(RepositoryConnection owner, O operation) {
            this.owner = owner;
            this.operation = operation;
        }

        public RepositoryConnection getOwner() {
            return this.owner;
        }

        public O getOperation() {
            return this.operation;
        }

        public void setOperation(O operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.owner + "=" + this.operation;
        }
    }
}

