/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;

class SailDatasetTripleSource
implements TripleSource {
    private final ValueFactory vf;
    private final SailDataset dataset;

    public SailDatasetTripleSource(ValueFactory vf, SailDataset dataset) {
        this.vf = vf;
        this.dataset = dataset;
    }

    public String toString() {
        return this.dataset.toString();
    }

    @Override
    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        try {
            return new Eval((Iteration<? extends Statement, ? extends Exception>)this.dataset.getStatements(subj, pred, obj, contexts));
        }
        catch (SailException e) {
            throw new QueryEvaluationException((Throwable)((Object)e));
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public static class Eval
    extends ExceptionConvertingIteration<Statement, QueryEvaluationException> {
        public Eval(Iteration<? extends Statement, ? extends Exception> iter) {
            super(iter);
        }

        protected QueryEvaluationException convert(Exception e) {
            return new QueryEvaluationException((Throwable)e);
        }
    }
}

