/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.DatatypeFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.DirectTupleFromFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;

public class DatatypePropertyShape
extends PathPropertyShape {
    private final Resource datatype;

    DatatypePropertyShape(Resource id, SailRepositoryConnection connection, Shape shape) {
        super(id, connection, shape);
        try (Stream stream = Iterations.stream(connection.getStatements(id, SHACL.DATATYPE, null, true, new Resource[0]));){
            this.datatype = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:datatype on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        LoggingNode addedByShape = new LoggingNode(shape.getPlanAddedStatements(shaclSailConnection, shape));
        BufferedSplitter bufferedSplitter = new BufferedSplitter(addedByShape);
        LoggingNode addedByPath = new LoggingNode(new Select(shaclSailConnection.getAddedStatements(), this.path.getQuery()));
        DirectTupleFromFilter invalidValuesDirectOnPath = new DirectTupleFromFilter();
        new DatatypeFilter(addedByPath, null, invalidValuesDirectOnPath, this.datatype);
        BufferedTupleFromFilter discardedRight = new BufferedTupleFromFilter();
        LoggingNode top = new LoggingNode(new InnerJoin(bufferedSplitter.getPlanNode(), invalidValuesDirectOnPath, null, discardedRight));
        if (shape instanceof TargetClass) {
            LoggingNode typeFilterPlan = new LoggingNode(((TargetClass)shape).getTypeFilterPlan(shaclSailConnection.getPreviousStateConnection(), discardedRight));
            top = new LoggingNode(new UnionNode(top, typeFilterPlan));
        }
        LoggingNode bulkedEcternalInnerJoin = new LoggingNode(new BulkedExternalInnerJoin(bufferedSplitter.getPlanNode(), shaclSailConnection.getPreviousStateConnection(), this.path.getQuery()));
        top = new LoggingNode(new UnionNode(top, bulkedEcternalInnerJoin));
        DirectTupleFromFilter invalidValues = new DirectTupleFromFilter();
        new DatatypeFilter(top, null, invalidValues, this.datatype);
        return new LoggingNode(invalidValues);
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return true;
    }
}

