/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.DatatypePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MaxCountPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MinCountPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;

public class PropertyShape
implements PlanGenerator,
RequiresEvalutation {
    private Resource id;
    Shape shape;

    PropertyShape(Resource id, Shape shape) {
        this.id = id;
        this.shape = shape;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return false;
    }

    static class Factory {
        Factory() {
        }

        static List<PropertyShape> getProprtyShapes(Resource ShapeId, SailRepositoryConnection connection, Shape shape) {
            try (Stream stream = Iterations.stream((Iteration)connection.getStatements(ShapeId, SHACL.PROPERTY, null, new Resource[0]));){
                List<PropertyShape> list = stream.map(Statement::getObject).map(v -> (Resource)v).flatMap(propertyShapeId -> {
                    ArrayList<PathPropertyShape> propertyShapes = new ArrayList<PathPropertyShape>(2);
                    if (Factory.hasMinCount(propertyShapeId, connection)) {
                        propertyShapes.add(new MinCountPropertyShape((Resource)propertyShapeId, connection, shape));
                    }
                    if (Factory.hasMaxCount(propertyShapeId, connection)) {
                        propertyShapes.add(new MaxCountPropertyShape((Resource)propertyShapeId, connection, shape));
                    }
                    if (Factory.hasDatatype(propertyShapeId, connection)) {
                        propertyShapes.add(new DatatypePropertyShape((Resource)propertyShapeId, connection, shape));
                    }
                    return propertyShapes.stream();
                }).collect(Collectors.toList());
                return list;
            }
        }

        private static boolean hasMinCount(Resource id, SailRepositoryConnection connection) {
            return connection.hasStatement(id, SHACL.MIN_COUNT, null, true, new Resource[0]);
        }

        private static boolean hasMaxCount(Resource id, SailRepositoryConnection connection) {
            return connection.hasStatement(id, SHACL.MAX_COUNT, null, true, new Resource[0]);
        }

        private static boolean hasDatatype(Resource id, SailRepositoryConnection connection) {
            return connection.hasStatement(id, SHACL.DATATYPE, null, true, new Resource[0]);
        }
    }
}

