/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.QueryGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;

public class Shape
implements PlanGenerator,
RequiresEvalutation,
QueryGenerator {
    private Resource id;
    private List<PropertyShape> propertyShapes;

    public Shape(Resource id, SailRepositoryConnection connection) {
        this.id = id;
        this.propertyShapes = PropertyShape.Factory.getProprtyShapes(id, connection, this);
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, Shape shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        return new TrimTuple(new LoggingNode(new Select(shaclSailConnection.getAddedStatements(), this.getQuery())), 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, Shape shape) {
        return new TrimTuple(new LoggingNode(new Select(shaclSailConnection.getRemovedStatements(), this.getQuery())), 1);
    }

    public List<PlanNode> generatePlans(ShaclSailConnection shaclSailConnection, Shape shape) {
        return this.propertyShapes.stream().filter(propertyShape -> propertyShape.requiresEvaluation(shaclSailConnection.getAddedStatements(), shaclSailConnection.getRemovedStatements())).map(propertyShape -> propertyShape.getPlan(shaclSailConnection, shape)).collect(Collectors.toList());
    }

    @Override
    public boolean requiresEvaluation(Repository addedStatements, Repository removedStatements) {
        return this.propertyShapes.stream().anyMatch(propertyShape -> propertyShape.requiresEvaluation(addedStatements, removedStatements));
    }

    @Override
    public String getQuery() {
        return "?a ?b ?c";
    }

    public String toString() {
        return this.id.toString();
    }

    public static class Factory {
        public static List<Shape> getShapes(SailRepositoryConnection connection) {
            try (Stream stream = Iterations.stream((Iteration)connection.getStatements(null, RDF.TYPE, (Value)SHACL.SHAPE, new Resource[0]));){
                List<Shape> list = stream.map(Statement::getSubject).map(shapeId -> {
                    if (Factory.hasTargetClass(shapeId, connection)) {
                        return new TargetClass((Resource)shapeId, connection);
                    }
                    return new Shape((Resource)shapeId, connection);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
        }

        private static boolean hasTargetClass(Resource shapeId, SailRepositoryConnection connection) {
            return connection.hasStatement(shapeId, SHACL.TARGET_CLASS, null, true, new Resource[0]);
        }
    }
}

