/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.Shape;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NotifyingSailConnection previousStateConnection;
    private Repository addedStatements;
    private Repository removedStatements;
    public final ShaclSail sail;
    public Stats stats;
    private HashSet<Statement> addedStatementsSet = new HashSet();
    private HashSet<Statement> removedStatementsSet = new HashSet();

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, NotifyingSailConnection previousStateConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.sail = sail;
        if (sail.config.validationEnabled) {
            this.addConnectionListener(new SailConnectionListener(){

                @Override
                public void statementAdded(Statement statement) {
                    boolean add = ShaclSailConnection.this.addedStatementsSet.add(statement);
                    if (!add) {
                        ShaclSailConnection.this.removedStatementsSet.remove(statement);
                    }
                }

                @Override
                public void statementRemoved(Statement statement) {
                    boolean add = ShaclSailConnection.this.removedStatementsSet.add(statement);
                    if (!add) {
                        ShaclSailConnection.this.addedStatementsSet.remove(statement);
                    }
                }
            });
        }
    }

    public NotifyingSailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public Repository getAddedStatements() {
        return this.addedStatements;
    }

    public Repository getRemovedStatements() {
        return this.removedStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel level) throws SailException {
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.previousStateConnection.begin((IsolationLevel)IsolationLevels.SNAPSHOT);
        }
    }

    private SailRepository getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
        SailRepository repository = new SailRepository(sail);
        repository.initialize();
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SailException {
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            try {
                boolean valid = this.validate();
                this.previousStateConnection.commit();
                if (!valid) {
                    this.rollback();
                    throw new SailException("Failed SHACL validation");
                }
                super.commit();
            }
            finally {
                this.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SailException {
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            this.previousStateConnection.commit();
            this.cleanup();
            super.rollback();
        }
    }

    private void cleanup() {
        if (this.addedStatements != null) {
            this.addedStatements.shutDown();
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
    }

    private boolean validate() {
        if (!this.sail.config.validationEnabled) {
            return true;
        }
        this.fillAddedAndRemovedStatementRepositories();
        boolean allValid = true;
        for (Shape shape : this.sail.shapes) {
            List<PlanNode> planNodes = shape.generatePlans(this, shape);
            for (PlanNode planNode : planNodes) {
                Stream stream = Iterations.stream(planNode.iterator());
                Throwable throwable = null;
                try {
                    boolean valid;
                    List collect = stream.collect(Collectors.toList());
                    boolean bl = valid = collect.size() == 0;
                    if (!valid) {
                        this.logger.warn("SHACL not valid. The following experimental debug results were produced: \n\tShape: {} \n\t\t{}", (Object)shape.toString(), (Object)String.join((CharSequence)"\n\t\t", collect.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.toList())));
                    }
                    allValid = allValid && valid;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        return allValid;
    }

    void fillAddedAndRemovedStatementRepositories() {
        this.addedStatements = this.getNewMemorySail();
        this.removedStatements = this.getNewMemorySail();
        this.addedStatementsSet.forEach(this.stats::added);
        this.removedStatementsSet.forEach(this.stats::removed);
        try (RepositoryConnection connection = this.addedStatements.getConnection();){
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.addedStatementsSet.stream().filter(statement -> !this.removedStatementsSet.contains(statement)).forEach(x$0 -> connection.add(x$0, new Resource[0]));
            connection.commit();
        }
        connection = this.removedStatements.getConnection();
        var2_2 = null;
        try {
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            this.removedStatementsSet.stream().filter(statement -> !this.addedStatementsSet.contains(statement)).forEach(x$0 -> connection.add(x$0, new Resource[0]));
            connection.commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var2_2 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    @Override
    public synchronized void close() throws SailException {
        if (this.isActive()) {
            this.rollback();
        }
        this.previousStateConnection.close();
        super.close();
    }

    public class Stats {
        boolean hasAdded;
        boolean hasRemoved;

        public void added(Statement statement) {
            this.hasAdded = true;
        }

        public void removed(Statement statement) {
            this.hasRemoved = true;
        }

        public boolean hasAdded() {
            return this.hasAdded;
        }

        public boolean hasRemoved() {
            return this.hasRemoved;
        }
    }
}

