/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class BulkedExternalInnerJoin
implements PlanNode {
    private IRI predicate;
    NotifyingSailConnection baseSailConnection;
    PlanNode leftNode;
    Repository repository;
    String query;

    public BulkedExternalInnerJoin(PlanNode leftNode, Repository repository, String query) {
        this.leftNode = leftNode;
        this.repository = repository;
        this.query = query;
    }

    public BulkedExternalInnerJoin(PlanNode leftNode, Repository repository, IRI predicate) {
        this.leftNode = leftNode;
        this.repository = repository;
        this.predicate = predicate;
    }

    public BulkedExternalInnerJoin(PlanNode leftNode, NotifyingSailConnection baseSailConnection, String query) {
        this.leftNode = leftNode;
        this.query = query;
        this.baseSailConnection = baseSailConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            LinkedList<Tuple> left = new LinkedList();
            LinkedList<Tuple> right = new LinkedList();
            CloseableIteration<Tuple, SailException> leftNodeIterator;
            {
                this.leftNodeIterator = BulkedExternalInnerJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                Throwable throwable;
                block82: {
                    boolean empty;
                    if (BulkedExternalInnerJoin.this.repository != null) {
                        throwable = null;
                        try (RepositoryConnection connection = BulkedExternalInnerJoin.this.repository.getConnection();){
                            boolean empty2;
                            boolean bl = empty2 = !connection.hasStatement((Resource)null, (IRI)null, null, true, new Resource[0]);
                            if (empty2) {
                                return;
                            }
                            break block82;
                        }
                        catch (Throwable empty2) {
                            throwable = empty2;
                            throw empty2;
                        }
                    }
                    boolean bl = empty = !BulkedExternalInnerJoin.this.baseSailConnection.hasStatement(null, null, null, true, new Resource[0]);
                    if (empty) {
                        return;
                    }
                }
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 100 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((Tuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                if (BulkedExternalInnerJoin.this.query != null) {
                    StringBuilder newQuery = new StringBuilder("select * where { VALUES (?a) { \n");
                    this.left.stream().map(tuple -> tuple.line.get(0)).map(v -> (Resource)v).forEach(r -> newQuery.append("( <").append(r.toString()).append("> )\n"));
                    newQuery.append("\n}").append(BulkedExternalInnerJoin.this.query).append("} order by ?a");
                    if (BulkedExternalInnerJoin.this.repository != null) {
                        try (RepositoryConnection connection = BulkedExternalInnerJoin.this.repository.getConnection();){
                            connection.begin((IsolationLevel)IsolationLevels.NONE);
                            try (Stream stream = Iterations.stream((Iteration)connection.prepareTupleQuery(newQuery.toString()).evaluate());){
                                stream.map(Tuple::new).forEach(this.right::addFirst);
                            }
                            connection.commit();
                        }
                    }
                    QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(newQuery.toString(), null);
                    try (CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate = BulkedExternalInnerJoin.this.baseSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);){
                        while (evaluate.hasNext()) {
                            BindingSet next2 = (BindingSet)evaluate.next();
                            this.right.addFirst(new Tuple(next2));
                        }
                    }
                }
                throwable = null;
                try (RepositoryConnection connection = BulkedExternalInnerJoin.this.repository.getConnection();){
                    connection.begin((IsolationLevel)IsolationLevels.NONE);
                    for (Tuple tuple2 : this.left) {
                        Stream stream = Iterations.stream((Iteration)connection.getStatements((Resource)tuple2.line.get(0), BulkedExternalInnerJoin.this.predicate, null, new Resource[0]));
                        Throwable throwable2 = null;
                        try {
                            stream.forEach(next -> this.right.addFirst(new Tuple(Arrays.asList(next.getSubject(), next.getObject()))));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    connection.commit();
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }

            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty() && !this.right.isEmpty();
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                if (!this.left.isEmpty()) {
                    Tuple leftPeek = this.left.peekLast();
                    Tuple joined = null;
                    if (!this.right.isEmpty()) {
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            joined = TupleHelper.join(leftPeek, rightPeek);
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 == null || !rightPeek2.line.get(0).equals(leftPeek.line.get(0))) {
                                this.left.removeLast();
                            }
                        }
                    }
                    if (joined != null) {
                        return joined;
                    }
                }
                return null;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }
}

