/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final int INITIAL_WAIT_TO_COLLECT = 10000;
    private static final int MAX_WAIT_TO_COLLECT = 5400000;
    private static final AtomicLong seq = new AtomicLong();
    private final Logger logger = LoggerFactory.getLogger(LockManager.class);
    private final boolean trackLocks;
    private int waitToCollect;
    private final Set<WeakLockReference> activeLocks = new HashSet<WeakLockReference>();

    public LockManager() {
        this(false);
    }

    public LockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public LockManager(boolean trackLocks, int collectionFrequency) {
        this.trackLocks = trackLocks || Properties.lockTrackingEnabled();
        this.waitToCollect = collectionFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveLock() {
        Set<WeakLockReference> set = this.activeLocks;
        synchronized (set) {
            return !this.activeLocks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForActiveLocks() throws InterruptedException {
        long now = -1L;
        while (true) {
            boolean nochange;
            Set<WeakLockReference> set = this.activeLocks;
            synchronized (set) {
                if (this.activeLocks.isEmpty()) {
                    return;
                }
                HashSet<WeakLockReference> before = new HashSet<WeakLockReference>(this.activeLocks);
                if (now < 0L) {
                    now = System.currentTimeMillis();
                }
                this.activeLocks.wait(this.waitToCollect);
                if (this.activeLocks.isEmpty()) {
                    return;
                }
                nochange = before.equals(this.activeLocks);
            }
            if (!nochange || System.currentTimeMillis() - now < (long)(this.waitToCollect / 2)) continue;
            this.releaseAbandoned();
            now = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Lock createLock(String alias) {
        final WeakLockReference weak = new WeakLockReference();
        weak.alias = alias;
        weak.acquiredName = Thread.currentThread().getName();
        weak.acquiredId = Thread.currentThread().getId();
        if (this.trackLocks) {
            weak.stack = new Throwable(alias + " lock " + seq.incrementAndGet() + " acquired in " + weak.acquiredName);
        }
        Lock lock = new Lock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean isActive() {
                Set set = LockManager.this.activeLocks;
                synchronized (set) {
                    return LockManager.this.activeLocks.contains(weak);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void release() {
                Set set = LockManager.this.activeLocks;
                synchronized (set) {
                    if (LockManager.this.activeLocks.remove(weak)) {
                        LockManager.this.activeLocks.notifyAll();
                    }
                }
            }

            public String toString() {
                if (weak.stack == null) {
                    return weak.alias + " lock acquired in " + weak.acquiredName;
                }
                return weak.stack.getMessage();
            }
        };
        weak.reference = new WeakReference<1>(lock);
        Set<WeakLockReference> set = this.activeLocks;
        synchronized (set) {
            this.activeLocks.add(weak);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAbandoned() {
        System.gc();
        Thread.yield();
        Set<WeakLockReference> set = this.activeLocks;
        synchronized (set) {
            if (!this.activeLocks.isEmpty()) {
                boolean stalled = true;
                Iterator<WeakLockReference> iter = this.activeLocks.iterator();
                while (iter.hasNext()) {
                    WeakLockReference lock = iter.next();
                    if (lock.reference.get() != null) continue;
                    iter.remove();
                    this.activeLocks.notifyAll();
                    stalled = false;
                    this.logAbandonedLock(lock);
                }
                if (stalled) {
                    if (this.waitToCollect < 5400000) {
                        this.waitToCollect *= 2;
                    }
                    this.logStalledLock(this.activeLocks);
                }
            }
        }
    }

    private void logAbandonedLock(WeakLockReference lock) {
        if (lock.stack == null && this.logger.isWarnEnabled()) {
            String msg = lock.alias + " lock abandoned; lock was acquired in {}; consider setting the {} system property";
            this.logger.warn(msg, (Object)lock.acquiredName, (Object)"info.aduna.concurrent.locks.trackLocks");
        } else if (this.logger.isWarnEnabled()) {
            String msg = lock.alias + " lock abandoned; lock was acquired in " + lock.acquiredName;
            this.logger.warn(msg, lock.stack);
        }
    }

    private void logStalledLock(Collection<WeakLockReference> activeLocks) {
        Thread current = Thread.currentThread();
        if (activeLocks.size() == 1) {
            WeakLockReference lock = activeLocks.iterator().next();
            if (this.logger.isWarnEnabled()) {
                String msg = "Thread " + current.getName() + " is waiting on an active " + lock.alias + " lock acquired in " + lock.acquiredName;
                if (lock.acquiredId == current.getId()) {
                    if (lock.stack == null) {
                        this.logger.warn(msg, new Throwable());
                    } else {
                        this.logger.warn(msg, new Throwable(lock.stack));
                    }
                } else if (lock.stack == null) {
                    this.logger.info(msg);
                } else {
                    this.logger.info(msg, new Throwable(lock.stack));
                }
            }
        } else {
            String alias = null;
            boolean warn = false;
            for (WeakLockReference lock : activeLocks) {
                warn |= lock.acquiredId == current.getId();
                if (alias == null) {
                    alias = lock.alias;
                    continue;
                }
                if (alias.contains(lock.alias)) continue;
                alias = alias + ", " + lock.alias;
            }
            String msg = "Thread " + current.getName() + " is waiting on " + activeLocks.size() + " active " + alias + " locks";
            if (warn) {
                this.logger.warn(msg);
            } else {
                this.logger.info(msg);
            }
        }
    }

    private static class WeakLockReference {
        String alias;
        String acquiredName;
        long acquiredId;
        Throwable stack;
        WeakReference<Lock> reference;

        private WeakLockReference() {
        }
    }
}

