/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.results.ModelInterface;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class ValidationReport
implements ModelInterface {
    private Resource id = SimpleValueFactory.getInstance().createBNode();
    private boolean conforms;
    private List<ValidationResult> validationResult = new ArrayList<ValidationResult>();

    public ValidationReport(boolean conforms) {
        this.conforms = conforms;
    }

    public void addValidationResult(ValidationResult validationResult) {
        this.validationResult.add(validationResult);
    }

    @Override
    public Model asModel(Model model) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        model.add(this.getId(), SHACL.CONFORMS, (Value)vf.createLiteral(this.conforms), new Resource[0]);
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_REPORT, new Resource[0]);
        for (ValidationResult result : this.validationResult) {
            model.add(this.getId(), SHACL.RESULT, (Value)result.getId(), new Resource[0]);
            result.asModel(model);
        }
        return model;
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public boolean conforms() {
        return this.conforms;
    }

    public List<ValidationResult> getValidationResult() {
        return this.validationResult;
    }
}

