/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigInteger;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.IntegerCastFunction;

public class PositiveIntegerCast
extends IntegerCastFunction {
    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.POSITIVE_INTEGER;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidPositiveInteger((String)lexicalValue);
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, BigInteger integerValue) {
        if (integerValue.compareTo(BigInteger.ZERO) > 0) {
            return Optional.of(vf.createLiteral(integerValue.toString(), this.getXsdDatatype()));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<Literal> createTypedLiteral(ValueFactory vf, boolean booleanValue) {
        Literal result = null;
        if (booleanValue) {
            result = vf.createLiteral("1", this.getXsdDatatype());
        }
        return Optional.ofNullable(result);
    }
}

