/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class UnBufferedPlanNode<T extends PlanNode & MultiStreamPlanNode>
implements PushablePlanNode {
    private T parent;
    Tuple next;
    private boolean closed;
    private boolean printed;

    UnBufferedPlanNode(T parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        this.next = null;
        this.closed = false;
        return new CloseableIteration<Tuple, SailException>(){
            {
                ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).init();
            }

            public void close() throws SailException {
                UnBufferedPlanNode.this.closed = true;
                ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return UnBufferedPlanNode.this.next != null;
            }

            private void calculateNext() {
                boolean success;
                while (UnBufferedPlanNode.this.next == null && (success = ((MultiStreamPlanNode)((Object)UnBufferedPlanNode.this.parent)).incrementIterator())) {
                }
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = UnBufferedPlanNode.this.next;
                UnBufferedPlanNode.this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.parent.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    @Override
    public void push(Tuple next) {
        this.next = next;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "UnBufferedPlanNode";
    }
}

