/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public abstract class ExceptionConvertingIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private final Iteration<? extends E, ? extends Exception> iter;

    public ExceptionConvertingIteration(Iteration<? extends E, ? extends Exception> iter) {
        assert (iter != null);
        this.iter = iter;
    }

    protected abstract X convert(Exception var1);

    @Override
    public boolean hasNext() throws X {
        try {
            return this.iter.hasNext();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public E next() throws X {
        try {
            return this.iter.next();
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public void remove() throws X {
        try {
            this.iter.remove();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        try {
            Iterations.closeCloseable(this.iter);
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }
}

