/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;

public class Iterations {
    public static <E, X extends Exception> List<E> asList(Iteration<? extends E, X> iter) throws X {
        ArrayList result = new ArrayList();
        Iterations.addAll(iter, result);
        return result;
    }

    public static <E, X extends Exception> Set<E> asSet(Iteration<? extends E, X> iter) throws X {
        HashSet result = new HashSet();
        Iterations.addAll(iter, result);
        return result;
    }

    public static <E, X extends Exception, C extends Collection<E>> C addAll(Iteration<? extends E, X> iter, C collection) throws X {
        try {
            while (iter.hasNext()) {
                collection.add(iter.next());
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return collection;
    }

    public static <X extends Exception> void closeCloseable(Iteration<?, X> iter) throws X {
        if (iter instanceof CloseableIteration) {
            ((CloseableIteration)iter).close();
        }
    }

    public static <X extends Exception> String toString(Iteration<?, X> iter, String separator) throws X {
        StringBuilder sb = new StringBuilder();
        Iterations.toString(iter, separator, sb);
        return sb.toString();
    }

    public static <X extends Exception> void toString(Iteration<?, X> iter, String separator, StringBuilder sb) throws X {
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
    }
}

