/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.mojo.eclipse.settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.scout.mojo.eclipse.settings.EclipseSettingsFile;
import org.eclipse.scout.mojo.eclipse.settings.JarFileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="eclipse-settings", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.NONE)
public class ProjectSettingsConfigurator
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectSettingsConfigurator.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor plugin;
    @Parameter
    private EclipseSettingsFile[] additionalConfig;
    @Parameter
    private boolean skip;

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.skip) {
                LOGGER.info("Skipping project settings configuration.");
            } else if (this.configureEclipseMeta()) {
                LOGGER.info("Project configured.");
            } else {
                LOGGER.error("Project not configured.");
            }
        }
        catch (IOException e) {
            LOGGER.error("Failure during settings configuration", (Throwable)e);
        }
    }

    private boolean configureEclipseMeta() throws IOException, MojoExecutionException {
        if (this.additionalConfig == null || this.additionalConfig.length <= 0) {
            LOGGER.warn("No settings specified.");
            return false;
        }
        List<Artifact> artifacts = this.collectArtifacts();
        List<JarFile> jarFiles = JarFileUtil.resolveJar(artifacts);
        this.writeAdditionalConfig(jarFiles);
        return true;
    }

    private List<Artifact> collectArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        PluginManagement pluginManagement = this.project.getBuild().getPluginManagement();
        if (pluginManagement != null) {
            artifacts.addAll(this.getEclipseProjectSettingsPluginDependenciesAsArtifacts(pluginManagement.getPluginsAsMap()));
        }
        artifacts.addAll(this.getEclipseProjectSettingsPluginDependenciesAsArtifacts(this.project.getBuild().getPluginsAsMap()));
        return artifacts;
    }

    private List<Artifact> getEclipseProjectSettingsPluginDependenciesAsArtifacts(Map<String, Plugin> plugins) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Plugin eclipseSettingsPlugin = plugins.get(String.valueOf(this.plugin.getGroupId()) + ":" + this.plugin.getArtifactId());
        if (eclipseSettingsPlugin != null) {
            for (Dependency dep : eclipseSettingsPlugin.getDependencies()) {
                String depKey = String.valueOf(dep.getGroupId()) + ":" + dep.getArtifactId();
                artifacts.add((Artifact)this.plugin.getArtifactMap().get(depKey));
            }
        }
        return artifacts;
    }

    private void writeAdditionalConfig(List<JarFile> jarFiles) throws MojoExecutionException {
        if (this.additionalConfig != null) {
            EclipseSettingsFile[] eclipseSettingsFileArray = this.additionalConfig;
            int n = this.additionalConfig.length;
            int n2 = 0;
            while (n2 < n) {
                block24: {
                    EclipseSettingsFile file = eclipseSettingsFileArray[n2];
                    File projectRelativeFile = new File(this.project.getBasedir(), file.getName());
                    if (projectRelativeFile.isDirectory()) {
                        LOGGER.warn(MessageFormat.format("{0} is a directory, ignoring.", projectRelativeFile.getAbsolutePath()));
                    }
                    projectRelativeFile.getParentFile().mkdirs();
                    try {
                        Throwable throwable = null;
                        Object var8_9 = null;
                        try (InputStream inStream = this.openStream(file.getLocation(), jarFiles);){
                            if (inStream != null) {
                                Throwable throwable2 = null;
                                Object var11_14 = null;
                                try (FileOutputStream outStream = new FileOutputStream(projectRelativeFile);){
                                    IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
                                    break block24;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            LOGGER.warn(MessageFormat.format("No file found at {0}", projectRelativeFile.getAbsolutePath()));
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        throw new MojoExecutionException(MessageFormat.format("Unable to write to file: {0}", projectRelativeFile.getAbsolutePath()));
                    }
                }
                ++n2;
            }
        }
    }

    private InputStream openStream(String filePath, List<JarFile> jarFiles) throws IOException {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        for (JarFile jarFile : jarFiles) {
            ZipEntry entry = jarFile.getEntry(filePath);
            if (entry == null) continue;
            return jarFile.getInputStream(entry);
        }
        LOGGER.warn("Entry " + filePath + " not found in " + jarFiles);
        return null;
    }
}

