/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.afs.types;

import java.nio.ByteBuffer;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.io.BufferProvider;

public interface AReadableFile
extends AFile.Wrapper {
    default public boolean open() {
        return this.actual().fileSystem().ioHandler().openReading(this);
    }

    default public boolean isOpen() {
        return this.actual().fileSystem().ioHandler().isOpen(this);
    }

    default public boolean close() {
        return this.actual().fileSystem().ioHandler().close(this);
    }

    default public boolean release() {
        boolean wasClosed = this.close();
        this.fileSystem().accessManager().unregister(this);
        return wasClosed;
    }

    @Override
    default public long size() {
        return this.fileSystem().ioHandler().size(this);
    }

    default public ByteBuffer readBytes() {
        return this.actual().fileSystem().ioHandler().readBytes(this);
    }

    default public ByteBuffer readBytes(long position) {
        return this.actual().fileSystem().ioHandler().readBytes(this, position);
    }

    default public ByteBuffer readBytes(long position, long length) {
        return this.actual().fileSystem().ioHandler().readBytes(this, position, length);
    }

    default public long readBytes(ByteBuffer targetBuffer) {
        return this.actual().fileSystem().ioHandler().readBytes(this, targetBuffer);
    }

    default public long readBytes(ByteBuffer targetBuffer, long position) {
        return this.actual().fileSystem().ioHandler().readBytes(this, targetBuffer, position);
    }

    default public long readBytes(ByteBuffer targetBuffer, long position, long length) {
        return this.actual().fileSystem().ioHandler().readBytes(this, targetBuffer, position, length);
    }

    default public long readBytes(BufferProvider bufferProvider) {
        return this.actual().fileSystem().ioHandler().readBytes(this, bufferProvider);
    }

    default public long readBytes(BufferProvider bufferProvider, long position) {
        return this.actual().fileSystem().ioHandler().readBytes(this, bufferProvider, position);
    }

    default public long readBytes(BufferProvider bufferProvider, long position, long length) {
        return this.actual().fileSystem().ioHandler().readBytes(this, bufferProvider, position, length);
    }

    default public long copyTo(AWritableFile target) {
        return this.actual().fileSystem().ioHandler().copyTo(this, target);
    }

    default public long copyTo(AWritableFile target, long sourcePosition) {
        return this.actual().fileSystem().ioHandler().copyTo(this, sourcePosition, target);
    }

    default public long copyTo(AWritableFile target, long sourcePosition, long length) {
        return this.actual().fileSystem().ioHandler().copyTo(this, sourcePosition, length, target);
    }

    public boolean retire();

    public boolean isRetired();

    public void validateIsNotRetired();
}

