/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.afs.types;

import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AFileSystem;

public interface AResolver<D, F> {
    public AFileSystem fileSystem();

    public String[] resolveDirectoryToPath(D var1);

    public String[] resolveFileToPath(F var1);

    public D resolve(ADirectory var1);

    public F resolve(AFile var1);

    default public ADirectory resolveDirectory(D directory) {
        String[] path = this.resolveDirectoryToPath(directory);
        return this.fileSystem().resolveDirectoryPath(path);
    }

    default public AFile resolveFile(F file) {
        String[] path = this.resolveFileToPath(file);
        return this.fileSystem().resolveFilePath(path);
    }

    default public ADirectory ensureDirectory(D directory) {
        String[] path = this.resolveDirectoryToPath(directory);
        return this.fileSystem().ensureDirectoryPath(path);
    }

    default public AFile ensureFile(F file) {
        String[] path = this.resolveFileToPath(file);
        return this.fileSystem().ensureFilePath(path);
    }
}

